/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.event;

import java.util.Set;
import net.gospi.mountsofmayhem.entity.ZombieNautilusEntity;
import net.gospi.mountsofmayhem.init.MountsOfMayhemModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="mounts_of_mayhem", bus=EventBusSubscriber.Bus.GAME)
public class ZombieNautilusRaiderSpawner {
    private static final Set<ResourceLocation> OCEAN_BIOMES = Set.of(ResourceLocation.parse((String)"minecraft:ocean"), ResourceLocation.parse((String)"minecraft:deep_ocean"), ResourceLocation.parse((String)"minecraft:cold_ocean"), ResourceLocation.parse((String)"minecraft:deep_cold_ocean"), ResourceLocation.parse((String)"minecraft:lukewarm_ocean"), ResourceLocation.parse((String)"minecraft:deep_lukewarm_ocean"), ResourceLocation.parse((String)"minecraft:warm_ocean"), ResourceLocation.parse((String)"minecraft:deep_frozen_ocean"));

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        ZombieNautilusEntity nautilus;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Entity entity = event.getEntity();
        if (!(entity instanceof Drowned)) {
            return;
        }
        Drowned drowned = (Drowned)entity;
        if (drowned.getPersistentData().getBoolean("MountedOnNautilus")) {
            return;
        }
        if (!drowned.isInWater()) {
            return;
        }
        if (!ZombieNautilusRaiderSpawner.isOceanBiome(level2, drowned.blockPosition())) {
            return;
        }
        if (level2.getRandom().nextFloat() > 0.1f) {
            return;
        }
        drowned.getPersistentData().putBoolean("MountedOnNautilus", true);
        float random = level2.getRandom().nextFloat();
        ItemStack weapon = random < 0.4f ? new ItemStack((ItemLike)Items.TRIDENT) : (random < 0.7f ? new ItemStack((ItemLike)Items.NAUTILUS_SHELL) : ItemStack.EMPTY);
        if (!weapon.isEmpty()) {
            drowned.setItemSlot(EquipmentSlot.MAINHAND, weapon);
            drowned.setDropChance(EquipmentSlot.MAINHAND, 0.05f);
        }
        if ((nautilus = (ZombieNautilusEntity)((EntityType)MountsOfMayhemModEntities.ZOMBIE_NAUTILUS.get()).create((Level)level2)) != null) {
            BlockPos pos = drowned.blockPosition();
            nautilus.moveTo(pos.getX(), pos.getY(), pos.getZ(), drowned.getYRot(), drowned.getXRot());
            nautilus.setPersistenceRequired();
            level2.addFreshEntity((Entity)nautilus);
            drowned.setPersistenceRequired();
            drowned.getNavigation().stop();
            drowned.setTarget(null);
            if (drowned.startRiding((Entity)nautilus, true)) {
                System.out.println("Drowned successfully mounted Zombie Nautilus");
                nautilus.setPersistenceRequired();
                drowned.setPersistenceRequired();
            }
        }
    }

    private static boolean isOceanBiome(ServerLevel level, BlockPos pos) {
        Biome biome = (Biome)level.getBiome(pos).value();
        ResourceLocation key = level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome);
        return key != null && OCEAN_BIOMES.contains(key);
    }
}

