/*
 * Decompiled with CFR 0.152.
 */
package net.gospi.mountsofmayhem.item;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class SpearItem
extends Item {
    private final int maxHoldTicks;
    private final int reloadTicks;
    private final double baseDamage;
    private final double speedMultiplier;
    private final double vehicleBonus;
    private static final ResourceLocation AIM_SPEED_MOD_ID = ResourceLocation.parse((String)"mounts_of_mayhem:spear_aim_speed");

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks, double baseDamage, double speedMultiplier, double vehicleBonus) {
        super(properties);
        this.maxHoldTicks = maxHoldTicks;
        this.reloadTicks = reloadTicks;
        this.baseDamage = baseDamage;
        this.speedMultiplier = speedMultiplier;
        this.vehicleBonus = vehicleBonus;
    }

    public SpearItem(Item.Properties properties, int maxHoldTicks, int reloadTicks) {
        this(properties, maxHoldTicks, reloadTicks, SpearItem.getDefaultBaseDamage(), SpearItem.getDefaultSpeedMultiplier(), SpearItem.getDefaultVehicleBonus());
    }

    private static double getDefaultBaseDamage() {
        return 4.0;
    }

    private static double getDefaultSpeedMultiplier() {
        return 1.4;
    }

    private static double getDefaultVehicleBonus() {
        return 1.25;
    }

    private double getMaterialBaseDamage() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 1.0;
            }
            case "StoneSpearItem": {
                return 2.0;
            }
            case "CopperSpearItem": {
                return 2.0;
            }
            case "GoldenSpearItem": {
                return 1.0;
            }
            case "IronSpearItem": {
                return 3.0;
            }
            case "DiamondSpearItem": {
                return 4.0;
            }
            case "NetheriteSpearItem": {
                return 5.0;
            }
        }
        return 4.0;
    }

    private double getMaterialSpeedMultiplier() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 1.0;
            }
            case "StoneSpearItem": {
                return 2.0;
            }
            case "CopperSpearItem": {
                return 2.0;
            }
            case "GoldenSpearItem": {
                return 1.0;
            }
            case "IronSpearItem": {
                return 3.0;
            }
            case "DiamondSpearItem": {
                return 4.0;
            }
            case "NetheriteSpearItem": {
                return 5.0;
            }
        }
        return 1.4;
    }

    private double getMaterialVehicleBonus() {
        String className;
        switch (className = ((Object)((Object)this)).getClass().getSimpleName()) {
            case "WoodenSpearItem": {
                return 1.0;
            }
            case "StoneSpearItem": {
                return 1.1;
            }
            case "CopperSpearItem": {
                return 1.15;
            }
            case "GoldenSpearItem": {
                return 0.9;
            }
            case "IronSpearItem": {
                return 1.25;
            }
            case "DiamondSpearItem": {
                return 1.4;
            }
            case "NetheriteSpearItem": {
                return 1.5;
            }
        }
        return 1.25;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) == null) {
            move.addTransientModifier(new AttributeModifier(AIM_SPEED_MOD_ID, 0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int remainingUseDuration) {
        LivingEntity target;
        int elapsed;
        if (level.isClientSide) {
            return;
        }
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            player.stopUsingItem();
            return;
        }
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) == null) {
            move.addTransientModifier(new AttributeModifier(AIM_SPEED_MOD_ID, 1.25, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        if ((elapsed = this.getUseDuration(stack, user) - remainingUseDuration) < 0) {
            elapsed = 0;
        }
        if (elapsed > 0 && (target = SpearItem.findTargetInFront(player, 5.0)) != null && target.isAlive()) {
            boolean moving;
            double speed = this.getMovementSpeed(player);
            float damage = this.computeDamage(speed, player);
            double dist = player.distanceTo((Entity)target);
            boolean inRange = dist <= 4.5;
            boolean bl = moving = speed >= 0.12;
            if (damage > 0.0f && inRange && moving) {
                DamageSource spearDamageSource = this.createSpearDamageSource(level, player);
                target.hurt(spearDamageSource, damage);
                Vec3 dir = player.getViewVector(1.0f);
                double materialSpeedMultiplier = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.speedMultiplier : this.getMaterialSpeedMultiplier();
                double kb = Math.min(0.3 + this.getMovementSpeed(player) * 0.8 * materialSpeedMultiplier, 0.8);
                target.push(dir.x * kb, 0.08, dir.z * kb);
                EquipmentSlot slot = player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                stack.hurtAndBreak(1, (LivingEntity)player, slot);
                this.removeSpeedModifier(player);
                player.stopUsingItem();
                player.getCooldowns().addCooldown((Item)this, this.reloadTicks);
            }
        }
    }

    private DamageSource createSpearDamageSource(Level level, Player player) {
        return new DamageSource(this, (Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.PLAYER_ATTACK), (Entity)player){

            public String getMsgId() {
                return "mounts_of_mayhem.spear_damage";
            }
        };
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity user, int timeLeft) {
        if (level.isClientSide) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            int elapsed = this.getUseDuration(stack, user) - timeLeft;
            if (elapsed >= this.maxHoldTicks) {
                player.getCooldowns().addCooldown((Item)this, this.reloadTicks);
            }
            this.removeSpeedModifier(player);
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            this.removeSpeedModifier(player);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            return 0;
        }
        return this.maxHoldTicks;
    }

    private void removeSpeedModifier(Player player) {
        AttributeInstance move = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (move != null && move.getModifier(AIM_SPEED_MOD_ID) != null) {
            move.removeModifier(AIM_SPEED_MOD_ID);
        }
    }

    protected static ItemAttributeModifiers createAttackAttributes(double attackDamage, double attackSpeed) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.parse((String)"mounts_of_mayhem:spear_attack_damage"), attackDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.parse((String)"mounts_of_mayhem:spear_attack_speed"), attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    private double getMovementSpeed(Player player) {
        Vec3 v = player.getDeltaMovement();
        double base = v.length();
        if (player.isPassenger() && player.getVehicle() != null) {
            Entity vehicle = player.getVehicle();
            Vec3 vehicleVel = vehicle.getDeltaMovement();
            double vehicleSpeed = vehicleVel.length();
            double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
            double vehicleMultiplier = 1.0;
            vehicleMultiplier = vehicle instanceof AbstractHorse ? 1.55 * materialVehicleBonus : (vehicle instanceof Camel ? 1.45 * materialVehicleBonus : (vehicle instanceof AbstractMinecart ? 1.35 * materialVehicleBonus : (vehicle instanceof Boat ? 1.35 * materialVehicleBonus : (vehicle instanceof Phantom ? 2.05 * materialVehicleBonus : 1.35 * materialVehicleBonus))));
            base = Math.max(base, vehicleSpeed * vehicleMultiplier);
        }
        if (player.isPassenger() && base < 0.1) {
            double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
            base = 0.325 * materialVehicleBonus;
        }
        return base;
    }

    private float computeDamage(double speed, Player player) {
        double minDamage;
        double materialBaseDamage = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.baseDamage : this.getMaterialBaseDamage();
        double materialSpeedMultiplier = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.speedMultiplier : this.getMaterialSpeedMultiplier();
        double materialVehicleBonus = this.baseDamage != SpearItem.getDefaultBaseDamage() ? this.vehicleBonus : this.getMaterialVehicleBonus();
        double speedInBlocksPerSecond = speed * 20.0;
        double damage = (materialBaseDamage + speedInBlocksPerSecond * 0.65) * materialSpeedMultiplier;
        if (player.isPassenger()) {
            damage *= materialVehicleBonus;
        }
        if (damage < (minDamage = materialBaseDamage * 0.75) && speed >= 0.12) {
            damage = minDamage;
        }
        return (float)damage;
    }

    private static LivingEntity findTargetInFront(Player player, double range) {
        Vec3 eye = player.getEyePosition(1.0f);
        Vec3 look = player.getViewVector(1.0f);
        Vec3 end = eye.add(look.scale(range));
        AABB box = new AABB(eye, end).inflate(0.5);
        List candidates = player.level().getEntities((Entity)player, box, e -> e instanceof LivingEntity && e != player);
        LivingEntity best = null;
        double bestDot = 0.9;
        for (Entity e2 : candidates) {
            Vec3 to = e2.position().add(0.0, (double)e2.getBbHeight() * 0.5, 0.0).subtract(eye).normalize();
            double dot = to.dot(look);
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            best = (LivingEntity)e2;
        }
        return best;
    }
}

