/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class LampBamboo
extends LanternBlock {
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    private static final VoxelShape SHAPE_HANGING = Block.box((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private static final VoxelShape SHAPE_STANDING = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0);

    public LampBamboo(BlockBehaviour.Properties p_153465_) {
        super(p_153465_);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HANGING) != false ? SHAPE_HANGING : SHAPE_STANDING;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pResult) {
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)ON, (Comparable)Boolean.valueOf((Boolean)pState.getValue((Property)ON) == false)), 3);
        float f = (Boolean)pState.getValue((Property)ON) != false ? 0.5f : 0.6f;
        pLevel.playSound((Player)null, pPos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.25f, f);
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{ON});
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)"tooltip.shift").withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"bamboo_lamp.description1").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"bamboo_lamp.description2").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, components, flag);
    }
}

