/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.corelib.dataserializers;

import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.world.item.ItemStack;

public class DataSerializerItemList {
    private static final StreamCodec<RegistryFriendlyByteBuf, NonNullList<ItemStack>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, NonNullList<ItemStack>>(){

        public void encode(RegistryFriendlyByteBuf buf, NonNullList<ItemStack> itemStacks) {
            buf.writeInt(itemStacks.size());
            for (ItemStack itemStack : itemStacks) {
                ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)itemStack);
            }
        }

        public NonNullList<ItemStack> decode(RegistryFriendlyByteBuf itemStacks) {
            int length = itemStacks.readInt();
            NonNullList list = NonNullList.withSize((int)length, (Object)ItemStack.EMPTY);
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, (Object)((ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)itemStacks)));
            }
            return list;
        }
    };

    public static EntityDataSerializer<NonNullList<ItemStack>> create() {
        return new EntityDataSerializer<NonNullList<ItemStack>>(){

            public StreamCodec<? super RegistryFriendlyByteBuf, NonNullList<ItemStack>> codec() {
                return CODEC;
            }

            public NonNullList<ItemStack> copy(NonNullList<ItemStack> itemStacks) {
                NonNullList list = NonNullList.withSize((int)itemStacks.size(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < itemStacks.size(); ++i) {
                    list.set(i, (Object)((ItemStack)itemStacks.get(i)).copy());
                }
                return list;
            }
        };
    }
}

