package com.yablon.furnitury.block;

import com.yablon.furnitury.FurnituryMod;
import com.yablon.furnitury.item.ModItems;
import com.yablon.furnitury.item.WaterCoolerBlockItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

import java.util.function.Supplier;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create(ForgeRegistries.BLOCKS, FurnituryMod.MOD_ID);

    public static final RegistryObject<Block> FURNITURE_WORKBENCH = registerBlock("furniture_workbench",
            () -> new FurnitureWorkbenchBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));

    public static final RegistryObject<Block> OAK_TABLE = registerBlock("oak_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> OAK_CHAIR = registerBlock("oak_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> OAK_STOOL = registerBlock("oak_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> OAK_DRESSER = registerBlock("oak_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> OAK_LOGS_PILE = registerBlock("oak_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> OAK_BENCH = registerBlock("oak_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> OAK_SITTABLE_LOG = registerBlock("oak_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> OAK_BOX = registerBlock("oak_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> OAK_SHELF = registerBlock("oak_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> OAK_CABINET = registerBlock("oak_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> OAK_COUNTER = registerBlock("oak_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> OAK_DISPLAY_CASE = registerBlock("oak_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));



    public static final RegistryObject<Block> SPRUCE_TABLE = registerBlock("spruce_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> SPRUCE_CHAIR = registerBlock("spruce_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> SPRUCE_STOOL = registerBlock("spruce_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> SPRUCE_DRESSER = registerBlock("spruce_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> SPRUCE_LOGS_PILE = registerBlock("spruce_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> SPRUCE_BENCH = registerBlock("spruce_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> SPRUCE_SITTABLE_LOG = registerBlock("spruce_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> SPRUCE_BOX = registerBlock("spruce_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> SPRUCE_SHELF = registerBlock("spruce_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> SPRUCE_CABINET = registerBlock("spruce_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> SPRUCE_COUNTER = registerBlock("spruce_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> SPRUCE_DISPLAY_CASE = registerBlock("spruce_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));


    public static final RegistryObject<Block> ACACIA_TABLE = registerBlock("acacia_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> ACACIA_CHAIR = registerBlock("acacia_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> ACACIA_STOOL = registerBlock("acacia_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> ACACIA_DRESSER = registerBlock("acacia_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> ACACIA_LOGS_PILE = registerBlock("acacia_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> ACACIA_BENCH = registerBlock("acacia_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> ACACIA_SITTABLE_LOG = registerBlock("acacia_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> ACACIA_BOX = registerBlock("acacia_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> ACACIA_SHELF = registerBlock("acacia_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> ACACIA_CABINET = registerBlock("acacia_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> ACACIA_COUNTER = registerBlock("acacia_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> ACACIA_DISPLAY_CASE = registerBlock("acacia_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));



    public static final RegistryObject<Block> DARK_OAK_TABLE = registerBlock("dark_oak_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> DARK_OAK_CHAIR = registerBlock("dark_oak_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> DARK_OAK_STOOL = registerBlock("dark_oak_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> DARK_OAK_DRESSER = registerBlock("dark_oak_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> DARK_OAK_LOGS_PILE = registerBlock("dark_oak_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> DARK_OAK_BENCH = registerBlock("dark_oak_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> DARK_OAK_SITTABLE_LOG = registerBlock("dark_oak_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> DARK_OAK_BOX = registerBlock("dark_oak_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> DARK_OAK_SHELF = registerBlock("dark_oak_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> DARK_OAK_CABINET = registerBlock("dark_oak_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> DARK_OAK_COUNTER = registerBlock("dark_oak_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> DARK_OAK_DISPLAY_CASE = registerBlock("dark_oak_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));


    public static final RegistryObject<Block> BIRCH_TABLE = registerBlock("birch_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> BIRCH_CHAIR = registerBlock("birch_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BIRCH_STOOL = registerBlock("birch_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BIRCH_DRESSER = registerBlock("birch_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> BIRCH_LOGS_PILE = registerBlock("birch_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> BIRCH_BENCH = registerBlock("birch_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BIRCH_SITTABLE_LOG = registerBlock("birch_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> BIRCH_BOX = registerBlock("birch_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BIRCH_SHELF = registerBlock("birch_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BIRCH_CABINET = registerBlock("birch_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BIRCH_COUNTER = registerBlock("birch_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BIRCH_DISPLAY_CASE = registerBlock("birch_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));



    public static final RegistryObject<Block> CHERRY_TABLE = registerBlock("cherry_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> CHERRY_CHAIR = registerBlock("cherry_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> CHERRY_STOOL = registerBlock("cherry_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> CHERRY_DRESSER = registerBlock("cherry_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> CHERRY_LOGS_PILE = registerBlock("cherry_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> CHERRY_BENCH = registerBlock("cherry_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CHERRY_SITTABLE_LOG = registerBlock("cherry_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> CHERRY_BOX = registerBlock("cherry_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CHERRY_SHELF = registerBlock("cherry_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CHERRY_CABINET = registerBlock("cherry_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CHERRY_COUNTER = registerBlock("cherry_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CHERRY_DISPLAY_CASE = registerBlock("cherry_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));


    public static final RegistryObject<Block> JUNGLE_TABLE = registerBlock("jungle_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> JUNGLE_CHAIR = registerBlock("jungle_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> JUNGLE_STOOL = registerBlock("jungle_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> JUNGLE_DRESSER = registerBlock("jungle_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> JUNGLE_LOGS_PILE = registerBlock("jungle_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> JUNGLE_BENCH = registerBlock("jungle_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> JUNGLE_SITTABLE_LOG = registerBlock("jungle_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> JUNGLE_BOX = registerBlock("jungle_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> JUNGLE_SHELF = registerBlock("jungle_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> JUNGLE_CABINET = registerBlock("jungle_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> JUNGLE_COUNTER = registerBlock("jungle_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> JUNGLE_DISPLAY_CASE = registerBlock("jungle_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));



    public static final RegistryObject<Block> CRIMSON_TABLE = registerBlock("crimson_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> CRIMSON_CHAIR = registerBlock("crimson_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> CRIMSON_STOOL = registerBlock("crimson_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> CRIMSON_DRESSER = registerBlock("crimson_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> CRIMSON_LOGS_PILE = registerBlock("crimson_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> CRIMSON_BENCH = registerBlock("crimson_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CRIMSON_SITTABLE_LOG = registerBlock("crimson_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> CRIMSON_BOX = registerBlock("crimson_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CRIMSON_SHELF = registerBlock("crimson_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CRIMSON_CABINET = registerBlock("crimson_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CRIMSON_COUNTER = registerBlock("crimson_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CRIMSON_DISPLAY_CASE = registerBlock("crimson_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));


    public static final RegistryObject<Block> WARPED_TABLE = registerBlock("warped_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> WARPED_CHAIR = registerBlock("warped_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> WARPED_STOOL = registerBlock("warped_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> WARPED_DRESSER = registerBlock("warped_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> WARPED_LOGS_PILE = registerBlock("warped_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> WARPED_BENCH = registerBlock("warped_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> WARPED_SITTABLE_LOG = registerBlock("warped_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> WARPED_BOX = registerBlock("warped_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> WARPED_SHELF = registerBlock("warped_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> WARPED_CABINET = registerBlock("warped_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> WARPED_COUNTER = registerBlock("warped_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> WARPED_DISPLAY_CASE = registerBlock("warped_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));



    public static final RegistryObject<Block> MANGROVE_TABLE = registerBlock("mangrove_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> MANGROVE_CHAIR = registerBlock("mangrove_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> MANGROVE_STOOL = registerBlock("mangrove_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> MANGROVE_DRESSER = registerBlock("mangrove_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> MANGROVE_LOGS_PILE = registerBlock("mangrove_logs_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 12, 16)));
    public static final RegistryObject<Block> MANGROVE_BENCH = registerBlock("mangrove_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> MANGROVE_SITTABLE_LOG = registerBlock("mangrove_sittable_log",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> MANGROVE_BOX = registerBlock("mangrove_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> MANGROVE_SHELF = registerBlock("mangrove_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> MANGROVE_CABINET = registerBlock("mangrove_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> MANGROVE_COUNTER = registerBlock("mangrove_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> MANGROVE_DISPLAY_CASE = registerBlock("mangrove_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));

    public static final RegistryObject<Block> BAMBOO_TABLE = registerBlock("bamboo_table",
            () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> BAMBOO_CHAIR = registerBlock("bamboo_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BAMBOO_STOOL = registerBlock("bamboo_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BAMBOO_DRESSER = registerBlock("bamboo_dresser",
            () -> new DresserBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> BAMBOO_BENCH = registerBlock("bamboo_bench",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BAMBOO_BOX = registerBlock("bamboo_box",
            () -> new BoxBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_SHELF = registerBlock("bamboo_shelf",
            () -> new ShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_CABINET = registerBlock("bamboo_cabinet",
            () -> new CabinetBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_COUNTER = registerBlock("bamboo_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_DISPLAY_CASE = registerBlock("bamboo_display_case",
            () -> new DisplayCaseBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_DOUBLE_SHELF = registerBlock("bamboo_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BAMBOO_GARDEN_CHAIR = registerBlock("bamboo_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BAMBOO_GARDEN_TABLE = registerBlock("bamboo_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> BAMBOO_BENCH_WB = registerBlock("bamboo_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BAMBOO_MODERN_TABLE = registerBlock("bamboo_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));

    public static final RegistryObject<Block> WHITE_LAMP = registerBlock("white_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));

    public static final RegistryObject<Block> ORANGE_LAMP = registerBlock("orange_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> LIME_LAMP = registerBlock("lime_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> GREEN_LAMP = registerBlock("green_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> LIGHT_BLUE_LAMP = registerBlock("light_blue_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> BLUE_LAMP = registerBlock("blue_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> RED_LAMP = registerBlock("red_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> CYAN_LAMP = registerBlock("cyan_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> YELLOW_LAMP = registerBlock("yellow_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> BROWN_LAMP = registerBlock("brown_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> LIGHT_GRAY_LAMP = registerBlock("light_gray_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));


    public static final RegistryObject<Block> WHITE_SOFA = registerBlock("white_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> RED_SOFA = registerBlock("red_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIME_SOFA = registerBlock("lime_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> GREEN_SOFA = registerBlock("green_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIGHT_BLUE_SOFA = registerBlock("light_blue_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BLUE_SOFA = registerBlock("blue_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> ORANGE_SOFA = registerBlock("orange_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CYAN_SOFA = registerBlock("cyan_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> YELLOW_SOFA = registerBlock("yellow_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BROWN_SOFA = registerBlock("brown_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIGHT_GRAY_SOFA = registerBlock("light_gray_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));


    public static final RegistryObject<Block> WHITE_CLOTH_CHAIR = registerBlock("white_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> ORANGE_CLOTH_CHAIR = registerBlock("orange_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> RED_CLOTH_CHAIR = registerBlock("red_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> LIGHT_BLUE_CLOTH_CHAIR = registerBlock("light_blue_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BLUE_CLOTH_CHAIR = registerBlock("blue_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> LIME_CLOTH_CHAIR = registerBlock("lime_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> GREEN_CLOTH_CHAIR = registerBlock("green_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> CYAN_CLOTH_CHAIR = registerBlock("cyan_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> YELLOW_CLOTH_CHAIR = registerBlock("yellow_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> BROWN_CLOTH_CHAIR = registerBlock("brown_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> LIGHT_GRAY_CLOTH_CHAIR = registerBlock("light_gray_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));

    public static final RegistryObject<Block> WHITE_SOFT_STOOL = registerBlock("white_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> ORANGE_SOFT_STOOL = registerBlock("orange_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> RED_SOFT_STOOL = registerBlock("red_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIGHT_BLUE_SOFT_STOOL = registerBlock("light_blue_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BLUE_SOFT_STOOL = registerBlock("blue_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIME_SOFT_STOOL = registerBlock("lime_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> GREEN_SOFT_STOOL = registerBlock("green_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CYAN_SOFT_STOOL = registerBlock("cyan_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> YELLOW_SOFT_STOOL = registerBlock("yellow_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BROWN_SOFT_STOOL = registerBlock("brown_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> LIGHT_GRAY_SOFT_STOOL = registerBlock("light_gray_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));


    public static final RegistryObject<Block> WHITE_CLOTH_BASKET = registerBlock("white_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> ORANGE_CLOTH_BASKET = registerBlock("orange_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> RED_CLOTH_BASKET = registerBlock("red_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> LIME_CLOTH_BASKET = registerBlock("lime_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> GREEN_CLOTH_BASKET = registerBlock("green_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> LIGHT_BLUE_CLOTH_BASKET = registerBlock("light_blue_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> BLUE_CLOTH_BASKET = registerBlock("blue_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> CYAN_CLOTH_BASKET = registerBlock("cyan_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> YELLOW_CLOTH_BASKET = registerBlock("yellow_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> BROWN_CLOTH_BASKET = registerBlock("brown_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));
    public static final RegistryObject<Block> LIGHT_GRAY_CLOTH_BASKET = registerBlock("light_gray_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));


    public static final RegistryObject<Block> OAK_SAPLING_POT = registerBlock("oak_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> SPRUCE_SAPLING_POT = registerBlock("spruce_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> BIRCH_SAPLING_POT = registerBlock("birch_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> ACACIA_SAPLING_POT = registerBlock("acacia_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> JUNGLE_SAPLING_POT = registerBlock("jungle_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> DARK_OAK_SAPLING_POT = registerBlock("dark_oak_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> CHERRY_SAPLING_POT = registerBlock("cherry_sapling_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));



    public static final RegistryObject<Block> ANDESITE_COUNTER = registerBlock("andesite_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> DIORITE_COUNTER = registerBlock("diorite_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> GRANITE_COUNTER = registerBlock("granite_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> CALCITE_COUNTER = registerBlock("calcite_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> BASALT_COUNTER = registerBlock("basalt_counter",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));


    public static final RegistryObject<Block> TRASHCAN = registerBlock("trashcan",
            () -> new TrashcanBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2.5F).noOcclusion()));
    public static final RegistryObject<Block> MODERN_TRASHCAN = registerBlock("modern_trashcan",
            () -> new TrashcanBlock(BlockBehaviour.Properties.of().sound(SoundType.DEEPSLATE_BRICKS).strength(2.5F).noOcclusion()));


    public static final RegistryObject<Block> GRAY_LAMP = registerBlock("gray_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> GRAY_SOFA = registerBlock("gray_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> GRAY_CLOTH_CHAIR = registerBlock("gray_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> GRAY_SOFT_STOOL = registerBlock("gray_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> GRAY_CLOTH_BASKET = registerBlock("gray_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));


    public static final RegistryObject<Block> HANGING_CEILING_LAMP = registerBlock("hanging_ceiling_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2F).noOcclusion(),
                    Block.box(6, 5, 6, 10, 16, 10)));
    public static final RegistryObject<Block> BIG_HANGING_CEILING_LAMP = registerBlock("big_hanging_ceiling_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2F).noOcclusion(),
                    Block.box(1, 2, 1, 15, 16, 15)));
    public static final RegistryObject<Block> FLAT_CEILING_LAMP = registerBlock("flat_ceiling_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2F).noOcclusion(),
                    Block.box(2, 13, 2, 14, 16, 14)));
    public static final RegistryObject<Block> INDUSTRIAL_CEILING_LAMP = registerBlock("industrial_ceiling_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2F).noOcclusion(),
                    Block.box(2, 10, 2, 14, 16, 14)));

    public static final RegistryObject<Block> MANGROVE_DOUBLE_SHELF = registerBlock("mangrove_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> ACACIA_DOUBLE_SHELF = registerBlock("acacia_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> BIRCH_DOUBLE_SHELF = registerBlock("birch_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CHERRY_DOUBLE_SHELF = registerBlock("cherry_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> CRIMSON_DOUBLE_SHELF = registerBlock("crimson_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> DARK_OAK_DOUBLE_SHELF = registerBlock("dark_oak_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> JUNGLE_DOUBLE_SHELF = registerBlock("jungle_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> OAK_DOUBLE_SHELF = registerBlock("oak_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> SPRUCE_DOUBLE_SHELF = registerBlock("spruce_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));
    public static final RegistryObject<Block> WARPED_DOUBLE_SHELF = registerBlock("warped_double_shelf",
            () -> new DoubleShelfBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F)));

    public static final RegistryObject<Block> PURPLE_LAMP = registerBlock("purple_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> PURPLE_SOFA = registerBlock("purple_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> PURPLE_CLOTH_CHAIR = registerBlock("purple_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> PURPLE_SOFT_STOOL = registerBlock("purple_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> PURPLE_CLOTH_BASKET = registerBlock("purple_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));


    public static final RegistryObject<Block> PINK_LAMP = registerBlock("pink_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> PINK_SOFA = registerBlock("pink_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> PINK_CLOTH_CHAIR = registerBlock("pink_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> PINK_SOFT_STOOL = registerBlock("pink_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> PINK_CLOTH_BASKET = registerBlock("pink_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));


    public static final RegistryObject<Block> MAGENTA_LAMP = registerBlock("magenta_lamp",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 11, 12)));
    public static final RegistryObject<Block> MAGENTA_SOFA = registerBlock("magenta_sofa",
            () -> new SofaBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> MAGENTA_CLOTH_CHAIR = registerBlock("magenta_cloth_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 8, 14)));
    public static final RegistryObject<Block> MAGENTA_SOFT_STOOL = registerBlock("magenta_soft_stool",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> MAGENTA_CLOTH_BASKET = registerBlock("magenta_cloth_basket",
            () -> new ClothBasketBlock(Block.Properties.of().strength(1.5f).sound(SoundType.WOOL).noOcclusion()));


    public static final RegistryObject<Block> RUSTIC_COUNTER = registerBlock("rustic_counter_one",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> RUSTIC_COUNTER_TWO = registerBlock("rustic_counter_two",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> RUSTIC_COUNTER_THREE = registerBlock("rustic_counter_three",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> RUSTIC_COUNTER_CORNER = registerBlock("rustic_counter_corner",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> DARK_RUSTIC_COUNTER = registerBlock("dark_rustic_counter_one",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> DARK_RUSTIC_COUNTER_TWO = registerBlock("dark_rustic_counter_two",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> DARK_RUSTIC_COUNTER_THREE = registerBlock("dark_rustic_counter_three",
            () -> new CounterBlock(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F)));
    public static final RegistryObject<Block> DARK_RUSTIC_COUNTER_CORNER = registerBlock("dark_rustic_counter_corner",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));

    public static final RegistryObject<Block> RUSTIC_ISLAND = registerBlock("rustic_island_arms",
            () -> new IslandBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> DARK_RUSTIC_ISLAND = registerBlock("dark_rustic_island_arms",
            () -> new IslandBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));

    public static final RegistryObject<Block> WOODEN_FLOOR_ONE = registerBlock("wooden_floor_one",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> WOODEN_FLOOR_TWO = registerBlock("wooden_floor_two",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> WOODEN_FLOOR_THREE = registerBlock("wooden_floor_three",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> WOODEN_FLOOR_FOUR = registerBlock("wooden_floor_four",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));


    public static final RegistryObject<Block> KITCHEN_FURNACE = registerBlock("kitchen_furnace",
            () -> new KitchenFurnaceBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2F).noOcclusion()));
    public static final RegistryObject<Block> MICROWAVE = registerBlock("microwave",
            () -> new MicrowaveBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2F).noOcclusion()));
    public static final RegistryObject<Block> FRIDGE = registerBlock("fridge",
            () -> new FridgeBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2F).noOcclusion()));
    public static final RegistryObject<Block> FREEZER = registerBlock("freezer",
            () -> new FreezerBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2F).noOcclusion(), FRIDGE.get()));


    public static final RegistryObject<Block> BIG_STONE_ROCK = registerBlock("big_stone_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> BIG_ANDESITE_ROCK = registerBlock("big_andesite_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> BIG_DIORITE_ROCK = registerBlock("big_diorite_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> BIG_GRANITE_ROCK = registerBlock("big_granite_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> BIG_COBBLESTONE_ROCK = registerBlock("big_cobblestone_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> BIG_MOSSY_COBBLESTONE_ROCK = registerBlock("big_mossy_cobblestone_rock",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 5, 14)));
    public static final RegistryObject<Block> ROCKS_PILE = registerBlock("rocks_pile",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));

    public static final RegistryObject<Block> GARDEN_LANTERN = registerBlock("garden_lantern",
            () -> new LampBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(2.5F).noOcclusion(),
                    Block.box(4, 0, 4, 12, 16, 12)));


    public static final RegistryObject<Block> OAK_GARDEN_CHAIR = registerBlock("oak_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> ACACIA_GARDEN_CHAIR = registerBlock("acacia_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BIRCH_GARDEN_CHAIR = registerBlock("birch_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CHERRY_GARDEN_CHAIR = registerBlock("cherry_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CRIMSON_GARDEN_CHAIR = registerBlock("crimson_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> DARK_OAK_GARDEN_CHAIR = registerBlock("dark_oak_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> JUNGLE_GARDEN_CHAIR = registerBlock("jungle_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> MANGROVE_GARDEN_CHAIR = registerBlock("mangrove_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> SPRUCE_GARDEN_CHAIR = registerBlock("spruce_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> WARPED_GARDEN_CHAIR = registerBlock("warped_garden_chair",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));

    public static final RegistryObject<Block> PICNIC_BASKET = registerBlock("picnic_basket",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(1, 0, 1, 15, 8, 15)));

    public static final RegistryObject<Block> OAK_GARDEN_TABLE = registerBlock("oak_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> ACACIA_GARDEN_TABLE = registerBlock("acacia_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> BIRCH_GARDEN_TABLE = registerBlock("birch_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> CHERRY_GARDEN_TABLE = registerBlock("cherry_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> CRIMSON_GARDEN_TABLE = registerBlock("crimson_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> DARK_OAK_GARDEN_TABLE = registerBlock("dark_oak_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> JUNGLE_GARDEN_TABLE = registerBlock("jungle_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> MANGROVE_GARDEN_TABLE = registerBlock("mangrove_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> SPRUCE_GARDEN_TABLE = registerBlock("spruce_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> WARPED_GARDEN_TABLE = registerBlock("warped_garden_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));


    public static final RegistryObject<Block> OAK_BENCH_WB = registerBlock("oak_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> ACACIA_BENCH_WB = registerBlock("acacia_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> BIRCH_BENCH_WB = registerBlock("birch_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CHERRY_BENCH_WB = registerBlock("cherry_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> CRIMSON_BENCH_WB = registerBlock("crimson_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> DARK_OAK_BENCH_WB = registerBlock("dark_oak_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> JUNGLE_BENCH_WB = registerBlock("jungle_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> MANGROVE_BENCH_WB = registerBlock("mangrove_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> SPRUCE_BENCH_WB = registerBlock("spruce_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));
    public static final RegistryObject<Block> WARPED_BENCH_WB = registerBlock("warped_bench_wb",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 8, 16)));


    public static final RegistryObject<Block> GRILL = registerBlock("grill",
            () -> new GrillBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(2F).noOcclusion()));


    public static final RegistryObject<Block> PLANT_IN_POT_ONE = registerBlock("plant_in_pot_one",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> PLANT_IN_POT_TWO = registerBlock("plant_in_pot_two",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> PLANT_IN_POT_THREE = registerBlock("plant_in_pot_three",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> PLANT_IN_POT_FOUR = registerBlock("plant_in_pot_four",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> PLANT_IN_POT_FIVE = registerBlock("plant_in_pot_five",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> BAMBOO_PLANT_WOOD_POT = registerBlock("bamboo_plant_wood_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> BAMBOO_PLANT_WHITE_POT = registerBlock("bamboo_plant_white_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> BAMBOO_PLANT_BLACK_POT = registerBlock("bamboo_plant_black_pot",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));
    public static final RegistryObject<Block> CACTUS_PLANT = registerBlock("cactus_plant",
            () -> new DirectionalBlock(
                    BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.5F).noOcclusion(),
                    Block.box(3, 0, 3, 13, 7, 13)));

    public static final RegistryObject<Block> OAK_MODERN_TABLE = registerBlock("oak_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> ACACIA_MODERN_TABLE = registerBlock("acacia_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> BIRCH_MODERN_TABLE = registerBlock("birch_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> CHERRY_MODERN_TABLE = registerBlock("cherry_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> CRIMSON_MODERN_TABLE = registerBlock("crimson_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> DARK_OAK_MODERN_TABLE = registerBlock("dark_oak_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> JUNGLE_MODERN_TABLE = registerBlock("jungle_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> MANGROVE_MODERN_TABLE = registerBlock("mangrove_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> SPRUCE_MODERN_TABLE = registerBlock("spruce_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));
    public static final RegistryObject<Block> WARPED_MODERN_TABLE = registerBlock("warped_modern_table",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 16, 16)));


    public static final RegistryObject<Block> WATER_BOTTLE = registerBlock("water_bottle",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(0.5F).noOcclusion(),
                    Block.box(2, 0, 2, 14, 16, 14)));
    public static final RegistryObject<Block> WATER_COOLER = BLOCKS.register("water_cooler",
            () -> new WaterCoolerBlock(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(1.5F).noOcclusion()));

    static {
        ModItems.ITEMS.register("water_cooler", () ->
                new WaterCoolerBlockItem(WATER_COOLER.get(), new Item.Properties()));
    }

    public static final RegistryObject<Block> SAND_CASTLE_RED = registerBlock("sand_castle_red",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(0.5F).noOcclusion(),
                    Block.box(1, 0, 1, 15, 12, 15)));
    public static final RegistryObject<Block> SAND_CASTLE_BLUE = registerBlock("sand_castle_blue",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(0.5F).noOcclusion(),
                    Block.box(1, 0, 1, 15, 12, 15)));
    public static final RegistryObject<Block> SAND_CASTLE_YELLOW = registerBlock("sand_castle_yellow",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(0.5F).noOcclusion(),
                    Block.box(1, 0, 1, 15, 12, 15)));
    public static final RegistryObject<Block> SAND_CASTLE_GREEN = registerBlock("sand_castle_green",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.SAND).strength(0.5F).noOcclusion(),
                    Block.box(1, 0, 1, 15, 12, 15)));
    public static final RegistryObject<Block> PICNIC_CARPET_WHITE_RED = registerBlock("picnic_carpet_white_red",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.MOSS_CARPET).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 1, 16)));
    public static final RegistryObject<Block> PICNIC_CARPET_WHITE_GREEN = registerBlock("picnic_carpet_white_green",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.MOSS_CARPET).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 1, 16)));
    public static final RegistryObject<Block> PICNIC_CARPET_WHITE_BLUE = registerBlock("picnic_carpet_white_blue",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.MOSS_CARPET).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 1, 16)));
    public static final RegistryObject<Block> PICNIC_CARPET_CYAN_BLUE = registerBlock("picnic_carpet_cyan_blue",
            () -> new DirectionalBlock(BlockBehaviour.Properties.of().sound(SoundType.MOSS_CARPET).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 1, 16)));


    public static final RegistryObject<Block> AIR_MATTRESS = registerBlock("air_mattress",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> PINK_AIR_MATTRESS = registerBlock("pink_air_mattress",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 6, 16)));
    public static final RegistryObject<Block> SWIMMING_RING = registerBlock("swimming_ring",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));
    public static final RegistryObject<Block> RED_SWIMMING_RING = registerBlock("red_swimming_ring",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));
    public static final RegistryObject<Block> LIME_SWIMMING_RING = registerBlock("lime_swimming_ring",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));
    public static final RegistryObject<Block> BLUE_SWIMMING_RING = registerBlock("blue_swimming_ring",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));
    public static final RegistryObject<Block> YELLOW_SWIMMING_RING = registerBlock("yellow_swimming_ring",
            () -> new ChairBlock(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.5F).noOcclusion(),
                    Block.box(0, 0, 0, 16, 3, 16)));



    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block){
        RegistryObject<T> toReturn = BLOCKS.register(name, block );

        if (!name.equals("water_cooler")) {
            registerBlockItem(name, toReturn);
        }

        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block){
        ModItems.ITEMS.register(name, () -> new BlockItem(block.get(), new Item.Properties()));
    }
    public static void register(IEventBus eventBus){
        BLOCKS.register(eventBus);
    }
}
