/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogwheelBlockItem;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class CoaxialGearBlockItem
extends CogwheelBlockItem {
    public CoaxialGearBlockItem(CoaxialGearBlock block, Item.Properties properties) {
        super((CogWheelBlock)block, properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (ShaftBlock.isShaft((BlockState)state)) {
            if (CoaxialGearBlock.tryMakeLongShaft(state, this.getBlock(), level, pos, context.getPlayer(), Direction.getFacingAxis((Entity)player, (Direction.Axis)((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS))))) {
                SoundType soundType = this.getBlock().defaultBlockState().getSoundType((LevelReader)level, pos, (Entity)player);
                level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                if (!level.isClientSide() && !player.isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            player.displayClientMessage((Component)Component.translatable((String)"petrolsparts.tooltip.coaxial_gear.shaft_too_short").withStyle(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        return super.onItemUseFirst(stack, context);
    }

    public static class ShaftOnGearPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return CoaxialGearBlock::isCoaxialGear;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS))));
        }
    }

    public static class GearOnShaftPlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return stack -> {
                BlockItem blockItem;
                Item patt0$temp = stack.getItem();
                return patt0$temp instanceof BlockItem && CoaxialGearBlock.isCoaxialGear((blockItem = (BlockItem)patt0$temp).getBlock());
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return ShaftBlock::isShaft;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            if (ShaftBlock.isShaft((BlockState)state)) {
                for (int i : Iterate.positiveAndNegative) {
                    if (!ShaftBlock.isShaft((BlockState)world.getBlockState(pos.offset(Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)((Direction.Axis)state.getValue((Property)ShaftBlock.AXIS))).getNormal().multiply(i))))) continue;
                    return PlacementOffset.success((Vec3i)pos, s -> (BlockState)s.setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)state.getValue((Property)RotatedPillarKineticBlock.AXIS))));
                }
            }
            return PlacementOffset.fail();
        }
    }
}

