/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.petrolsparts.content.coaxial_gear.CoaxialGearBlock;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.petrolsparts.mixin.accessor.RotationPropagatorAccessor;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LongShaftBlockEntity
extends BracketedKineticBlockEntity {
    public LongShaftBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.isVirtual() || !this.hasLevel()) {
            return;
        }
        BlockState coaxialGearState = this.getLevel().getBlockState(this.getBlockPos().relative(DirectionalRotatedPillarKineticBlock.getDirection(this.getBlockState())));
        if (!CoaxialGearBlock.isCoaxialGear(coaxialGearState) || coaxialGearState.getValue((Property)RotatedPillarKineticBlock.AXIS) != this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS) || !((Boolean)coaxialGearState.getValue((Property)CoaxialGearBlock.HAS_SHAFT)).booleanValue()) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)AllBlocks.SHAFT.getDefaultState().setValue((Property)RotatedPillarKineticBlock.AXIS, (Comparable)((Direction.Axis)this.getBlockState().getValue((Property)RotatedPillarKineticBlock.AXIS))));
        }
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(stateFrom);
        if (LongShaftBlockEntity.connectedToLongShaft(target, (KineticBlockEntity)this, BlockPos.ZERO.subtract((Vec3i)diff))) {
            return 1.0f / RotationPropagatorAccessor.invokeGetAxisModifier(target, direction.getOpposite());
        }
        return 0.0f;
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        super.addPropagationLocations(block, state, neighbours);
        neighbours.add(this.getBlockPos().relative(DirectionalRotatedPillarKineticBlock.getDirection(state), 2));
        return neighbours;
    }

    public boolean isCustomConnection(KineticBlockEntity other, BlockState state, BlockState otherState) {
        Block block = otherState.getBlock();
        if (block instanceof IRotate) {
            IRotate defTo = (IRotate)block;
            Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(state);
            return BlockPos.ZERO.relative(direction, 2).equals((Object)other.getBlockPos().subtract((Vec3i)this.getBlockPos())) && defTo.hasShaftTowards((LevelReader)this.getLevel(), other.getBlockPos(), otherState, direction.getOpposite());
        }
        return false;
    }

    public static boolean connectedToLongShaft(KineticBlockEntity be, KineticBlockEntity potentialLongShaft, BlockPos diff) {
        if (potentialLongShaft instanceof LongShaftBlockEntity) {
            LongShaftBlockEntity longShaft = (LongShaftBlockEntity)potentialLongShaft;
            Block block = be.getBlockState().getBlock();
            if (block instanceof IRotate) {
                IRotate defFrom = (IRotate)block;
                Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(longShaft.getBlockState());
                return diff.equals((Object)BlockPos.ZERO.relative(direction.getOpposite(), 2)) && defFrom.hasShaftTowards((LevelReader)be.getLevel(), be.getBlockPos(), be.getBlockState(), direction.getOpposite());
            }
        }
        return false;
    }
}

