/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.corner_shaft;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.petrolsparts.PetrolsPartsPartialModels;
import com.petrolpark.petrolsparts.content.corner_shaft.CornerShaftBlock;
import com.petrolpark.petrolsparts.content.corner_shaft.CornerShaftBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class EncasedCornerShaftRenderer
extends KineticBlockEntityRenderer<CornerShaftBlockEntity> {
    public EncasedCornerShaftRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CornerShaftBlockEntity cornerShaftBlockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)cornerShaftBlockEntity.getLevel());
        BlockState state = cornerShaftBlockEntity.getBlockState();
        VertexConsumer vbSolid = buffer.getBuffer(RenderType.solid());
        Direction[] directions = CornerShaftBlock.getDirectionsConnectedByState(state);
        Direction shaft1Direction = directions[0];
        Direction shaft2Direction = directions[1];
        float gimbal1Angle = (float)Math.PI * (time * this.getSpeed(cornerShaftBlockEntity, shaft1Direction) * 3.0f / 10.0f % 360.0f) / 180.0f;
        float gimbal2Angle = (float)Math.PI * (time * this.getSpeed(cornerShaftBlockEntity, shaft2Direction) * 3.0f / 10.0f % 360.0f) / 180.0f;
        float offset1 = (float)Math.PI * EncasedCornerShaftRenderer.getRotationOffsetForPosition((KineticBlockEntity)cornerShaftBlockEntity, (BlockPos)cornerShaftBlockEntity.getBlockPos(), (Direction.Axis)shaft1Direction.getAxis()) / 180.0f;
        float offset2 = (float)Math.PI * EncasedCornerShaftRenderer.getRotationOffsetForPosition((KineticBlockEntity)cornerShaftBlockEntity, (BlockPos)cornerShaftBlockEntity.getBlockPos(), (Direction.Axis)shaft2Direction.getAxis()) / 180.0f;
        SuperByteBuffer shaft1 = CachedBuffers.partialFacing((PartialModel)PetrolsPartsPartialModels.CORNER_SHAFT_SIDE, (BlockState)state, (Direction)shaft1Direction);
        EncasedCornerShaftRenderer.kineticRotationTransform((SuperByteBuffer)shaft1, (KineticBlockEntity)cornerShaftBlockEntity, (Direction.Axis)shaft1Direction.getAxis(), (float)(gimbal1Angle + offset1), (int)light);
        shaft1.renderInto(ms, vbSolid);
        SuperByteBuffer shaft2 = CachedBuffers.partialFacing((PartialModel)PetrolsPartsPartialModels.CORNER_SHAFT_SIDE, (BlockState)state, (Direction)shaft2Direction);
        EncasedCornerShaftRenderer.kineticRotationTransform((SuperByteBuffer)shaft2, (KineticBlockEntity)cornerShaftBlockEntity, (Direction.Axis)shaft2Direction.getAxis(), (float)(gimbal2Angle + offset2), (int)light);
        shaft2.renderInto(ms, vbSolid);
        this.renderMiddle(cornerShaftBlockEntity, state, ms, vbSolid, light, shaft1Direction, shaft2Direction, gimbal1Angle, gimbal2Angle);
    }

    protected void renderMiddle(CornerShaftBlockEntity be, BlockState state, PoseStack ms, VertexConsumer vc, int light, Direction shaft1Direction, Direction shaft2Direction, float gimbal1Angle, float gimbal2Angle) {
    }

    protected float getSpeed(CornerShaftBlockEntity blockEntity, Direction face) {
        float speed;
        Direction sourceFacing = null;
        if (blockEntity.hasSource()) {
            BlockPos source = blockEntity.source.subtract((Vec3i)blockEntity.getBlockPos());
            sourceFacing = Direction.getNearest((float)source.getX(), (float)source.getY(), (float)source.getZ());
        }
        if ((speed = blockEntity.getSpeed()) != 0.0f && sourceFacing != null && sourceFacing.getAxisDirection() == face.getAxisDirection() && face != sourceFacing) {
            speed *= -1.0f;
        }
        return speed;
    }

    protected Direction getSourceFacing(CornerShaftBlockEntity blockEntity) {
        if (blockEntity.hasSource()) {
            BlockPos source = blockEntity.source.subtract((Vec3i)blockEntity.getBlockPos());
            return Direction.getNearest((float)source.getX(), (float)source.getY(), (float)source.getZ());
        }
        return null;
    }

    protected Direction.Axis getAxis(Direction shaft1Direction, Direction shaft2Direction) {
        ArrayList<Direction.Axis> axes = new ArrayList<Direction.Axis>();
        axes.addAll(List.of(Direction.Axis.values()));
        axes.remove(shaft1Direction.getAxis());
        axes.remove(shaft2Direction.getAxis());
        return (Direction.Axis)axes.get(0);
    }
}

