/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.differential;

import com.petrolpark.compat.create.core.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.differential.DifferentialBlockEntity;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DifferentialBlock
extends CogWheelBlock {
    public static final BooleanProperty FULL_MODEL = BooleanProperty.create((String)"full_model");

    public DifferentialBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FULL_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION});
        builder.add(new Property[]{FULL_MODEL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FULL_MODEL, (Comparable)Boolean.valueOf(false));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (((Boolean)state.getValue((Property)FULL_MODEL)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FULL_MODEL, (Comparable)Boolean.valueOf(false)));
        }
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)worldIn, (BlockPos)pos, (LivingEntity)placer);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.withBlockEntityDo((BlockGetter)level, pos, be -> {
            DifferentialBlockEntity differential;
            BlockEntity neighborBE = level.getBlockEntity(neighbor);
            Direction directionBetween = KineticsHelper.directionBetween((BlockPos)pos, (BlockPos)neighbor);
            Direction differentialDirection = DirectionalRotatedPillarKineticBlock.getDirection(state);
            if (be instanceof DifferentialBlockEntity && (differential = (DifferentialBlockEntity)((Object)be)).hasLevel() && directionBetween == differentialDirection.getOpposite()) {
                float newControlSpeed = 0.0f;
                if (neighborBE instanceof KineticBlockEntity) {
                    KineticBlockEntity kbe = (KineticBlockEntity)neighborBE;
                    newControlSpeed = differential.getPropagatedSpeed(kbe, differentialDirection);
                }
                if (differential.oldControlSpeed != newControlSpeed) {
                    differential.getLevel().scheduleTick(pos, (Block)this, 1);
                }
            }
        });
        super.onNeighborChange(state, level, pos, neighbor);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)PetrolsPartsBlocks.DUMMY_DIFFERENTIAL.getDefaultState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)))).setValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)((Boolean)state.getValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION))));
        PetrolsPartsAdvancementBehaviour behaviour = (PetrolsPartsAdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)pos, PetrolsPartsAdvancementBehaviour.TYPE);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)behaviour.getPlayer());
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == DirectionalRotatedPillarKineticBlock.getDirection(state);
    }

    public boolean isLargeCog() {
        return true;
    }

    public boolean isDedicatedCogWheel() {
        return true;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.DIFFERENTIAL.get();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.getValue((Property)AXIS);
    }
}

