/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.differential;

import com.petrolpark.compat.create.core.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.content.coaxial_gear.LongShaftBlockEntity;
import com.petrolpark.petrolsparts.content.differential.DifferentialBlock;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTriggers;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.petrolpark.petrolsparts.mixin.accessor.RotationPropagatorAccessor;
import com.petrolpark.util.KineticsHelper;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DifferentialBlockEntity
extends SplitShaftBlockEntity {
    public PetrolsPartsAdvancementBehaviour advancementBehaviour;
    public float oldControlSpeed;

    public DifferentialBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new PetrolsPartsAdvancementBehaviour((SmartBlockEntity)this, PetrolsPartsAdvancementTriggers.DIFFERENTIAL);
        behaviours.add((BlockEntityBehaviour)this.advancementBehaviour);
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (connectedViaAxes || LongShaftBlockEntity.connectedToLongShaft((KineticBlockEntity)this, target, diff)) {
            if (target instanceof DifferentialBlockEntity) {
                return 0.0f;
            }
            return this.ratio(stateFrom) * Math.signum(RotationPropagatorAccessor.invokeGetAxisModifier(target, KineticsHelper.directionBetween((BlockPos)target.getBlockPos(), (BlockPos)this.getBlockPos())));
        }
        return super.propagateRotationTo(target, stateFrom, stateTo, diff, connectedViaAxes, connectedViaCogs);
    }

    public void setSource(BlockPos source) {
        super.setSource(source);
        Direction directionBetween = KineticsHelper.directionBetween((BlockPos)this.getBlockPos(), (BlockPos)source);
        if (this.hasLevel() && (directionBetween == null || directionBetween.getAxis() != this.getBlockState().getValue((Property)DifferentialBlock.AXIS))) {
            this.getLevel().destroyBlock(this.getBlockPos(), true);
        }
    }

    public void tick() {
        BlockEntity blockEntity;
        BlockPos adjacentPos;
        super.tick();
        if (!this.hasLevel()) {
            return;
        }
        Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(this.getBlockState());
        BlockPos otherAdjacentPos = this.getBlockPos().relative(direction.getOpposite());
        if (this.getSpeed() == 0.0f && !this.propagatesToMe(adjacentPos = this.getBlockPos().relative(direction), direction.getOpposite()) && this.propagatesToMe(otherAdjacentPos, direction)) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)((BlockState)PetrolsPartsBlocks.DUMMY_DIFFERENTIAL.getDefaultState().setValue((Property)DifferentialBlock.AXIS, (Comparable)direction.getAxis())).setValue((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.getAxisDirection() == Direction.AxisDirection.NEGATIVE)));
            AbstractRememberPlacerBehaviour.setPlacedBy((Level)this.level, (BlockPos)this.getBlockPos(), (LivingEntity)this.advancementBehaviour.getPlayer());
        }
        if ((blockEntity = this.getLevel().getBlockEntity(otherAdjacentPos)) instanceof KineticBlockEntity) {
            KineticBlockEntity kbe = (KineticBlockEntity)blockEntity;
            this.oldControlSpeed = this.getPropagatedSpeed(kbe, direction);
        }
    }

    public void onSpeedChanged(float previousSpeed) {
        KineticBlockEntity kbe;
        BlockEntity blockEntity;
        super.onSpeedChanged(previousSpeed);
        if (this.speed == 0.0f || this.advancementBehaviour.getPlayer() == null) {
            return;
        }
        Direction direction = DirectionalRotatedPillarKineticBlock.getDirection(this.getBlockState());
        BlockPos otherAdjacentPos = this.getBlockPos().relative(direction.getOpposite());
        if (this.propagatesToMe(otherAdjacentPos, direction) && (blockEntity = this.getLevel().getBlockEntity(otherAdjacentPos)) instanceof KineticBlockEntity && (kbe = (KineticBlockEntity)blockEntity).getSpeed() != 0.0f) {
            this.advancementBehaviour.awardAdvancement(PetrolsPartsAdvancementTriggers.DIFFERENTIAL);
        }
    }

    public void removeSource() {
        super.removeSource();
        if (this.hasLevel()) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().cycle((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION));
        }
    }

    public float ratio(BlockState stateFrom) {
        Direction towardsInput = DirectionalRotatedPillarKineticBlock.getDirection(stateFrom);
        Direction towardsControl = towardsInput.getOpposite();
        BlockPos inputPos = this.getBlockPos().relative(towardsInput);
        BlockPos controlPos = this.getBlockPos().relative(towardsControl);
        BlockEntity inputBE = this.getLevel().getBlockEntity(inputPos);
        float inputSpeed = 0.0f;
        if (this.propagatesToMe(inputPos, towardsControl) && inputBE instanceof KineticBlockEntity) {
            KineticBlockEntity inputKBE = (KineticBlockEntity)inputBE;
            inputSpeed = this.getPropagatedSpeed(inputKBE, towardsControl);
        }
        BlockEntity controlBE = this.getLevel().getBlockEntity(controlPos);
        float controlSpeed = 0.0f;
        if (this.propagatesToMe(controlPos, towardsInput) && controlBE instanceof KineticBlockEntity) {
            KineticBlockEntity controlKBE = (KineticBlockEntity)controlBE;
            controlSpeed = this.getPropagatedSpeed(controlKBE, towardsInput);
        }
        if (inputSpeed + controlSpeed == 0.0f) {
            return 0.0f;
        }
        return 2.0f * inputSpeed / (inputSpeed + controlSpeed);
    }

    public boolean propagatesToMe(BlockPos pos, Direction directionToMe) {
        KineticBlock kineticBlock;
        if (!this.hasLevel()) {
            return false;
        }
        BlockState state = this.getLevel().getBlockState(pos);
        Block block = state.getBlock();
        return block instanceof KineticBlock && (kineticBlock = (KineticBlock)block).hasShaftTowards((LevelReader)this.getLevel(), pos, state, directionToMe);
    }

    public float getPropagatedSpeed(KineticBlockEntity from, Direction directionToMe) {
        if (from instanceof DifferentialBlockEntity) {
            return 0.0f;
        }
        return from.getSpeed() * RotationPropagatorAccessor.invokeGetAxisModifier(from, directionToMe);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        super.addPropagationLocations(block, state, neighbours);
        KineticsHelper.addLargeCogwheelPropagationLocations((BlockPos)this.worldPosition, neighbours);
        return neighbours;
    }

    protected boolean canPropagateDiagonally(IRotate block, BlockState state) {
        return true;
    }

    public float getRotationSpeedModifier(Direction face) {
        return this.ratio(this.getBlockState());
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(1.0);
    }
}

