/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.hydraulic_transmission;

import com.petrolpark.compat.create.core.tube.ITubeBlockEntity;
import com.petrolpark.compat.create.core.tube.TubeBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.util.MathsHelper;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class HydraulicTransmissionBlockEntity
extends KineticBlockEntity
implements ITubeBlockEntity {
    public TubeBehaviour tube;

    public HydraulicTransmissionBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tube = new TubeBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.tube);
    }

    public void destroy() {
        super.destroy();
        this.tube.disconnect();
    }

    public void invalidateTubeRenderBoundingBox() {
        this.invalidateRenderBoundingBox();
    }

    protected AABB createRenderBoundingBox() {
        if (this.tube == null || !this.tube.isController() || this.tube.getSpline() == null) {
            return super.createRenderBoundingBox();
        }
        return MathsHelper.expandToInclude((AABB)this.tube.getSpline().getOccupiedVolume(), (BlockPos)this.getBlockPos());
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.updatePartnerSpeed();
    }

    public void afterTubeConnect() {
        this.updateSpeed = true;
        this.updatePartnerSpeed();
    }

    public void beforeTubeDisconnect() {
        this.detachKinetics();
    }

    public void updatePartnerSpeed() {
        if (this.tube.getOtherEndPos() != null) {
            this.getLevel().getBlockEntity(this.tube.getOtherEndPos(), (BlockEntityType)PetrolsPartsBlockEntityTypes.HYDRAULIC_TRANSMISSION.get()).ifPresent(be -> {
                be.updateSpeed = true;
            });
        }
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        if (this.tube.getOtherEndPos() != null) {
            neighbours.add(this.tube.getOtherEndPos());
        }
        return neighbours;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (target.getBlockPos().equals((Object)this.tube.getOtherEndPos())) {
            return 1.0f;
        }
        return 0.0f;
    }
}

