/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.pneumatic_tube;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.core.tube.ITubeBlockEntity;
import com.petrolpark.compat.create.core.tube.TubeBehaviour;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.core.item.QueueItemHandler;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsConfigs;
import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeBlock;
import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeItemTransportPacket;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTriggers;
import com.petrolpark.util.BlockFace;
import com.petrolpark.util.ClampedCubicSpline;
import com.petrolpark.util.ItemHelper;
import com.petrolpark.util.MathsHelper;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.deployer.DeployerFilterSlot;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.CapManipulationBehaviourBase;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryTrackerBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PneumaticTubeBlockEntity
extends KineticBlockEntity
implements ITubeBlockEntity {
    public static final int DISTANCE_PER_BLOCK = 320;
    public TubeBehaviour tube;
    protected Optional<Either<Input, Output>> handler = Optional.empty();
    protected FilteringBehaviour filtering;
    protected InvManipulationBehaviour targetInventory;
    protected VersionedInventoryTrackerBehaviour invVersionTracker;
    protected DirectBeltInputBehaviour beltInput;
    protected final QueueItemHandler itemBacklog = new QueueItemHandler();
    protected PetrolsPartsAdvancementBehaviour advancements;
    protected boolean removeHandlerClient = false;
    protected boolean updateFromSpeedClient = false;

    public PneumaticTubeBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.tube = new TubeBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.tube);
        this.beltInput = new DirectBeltInputBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.beltInput);
        this.targetInventory = new InvManipulationBehaviour((SmartBlockEntity)this, CapManipulationBehaviourBase.InterfaceProvider.oppositeOfBlockFacing());
        behaviours.add((BlockEntityBehaviour)this.targetInventory);
        this.advancements = new PetrolsPartsAdvancementBehaviour((SmartBlockEntity)this, PetrolsPartsAdvancementTriggers.PNEUMATIC_TUBE);
        behaviours.add((BlockEntityBehaviour)this.advancements);
        this.invVersionTracker = new VersionedInventoryTrackerBehaviour((SmartBlockEntity)this);
        behaviours.add((BlockEntityBehaviour)this.invVersionTracker);
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new PneumaticTubeValueBoxTransform(this)).showCountWhen(this::supportsAmountOnFilter).onlyActiveWhen(this::isInput).withCallback(this::onFilterChanged);
        behaviours.add((BlockEntityBehaviour)this.filtering);
    }

    public Optional<Either<Input, Output>> getHandler() {
        return this.handler;
    }

    public PneumaticTubeBlockEntity removeHandler() {
        this.handler = Optional.empty();
        this.removeHandlerClient = true;
        return this;
    }

    protected Optional<PneumaticTubeBlockEntity> getOther() {
        if (this.tube.getOtherEndPos() == null) {
            return Optional.empty();
        }
        return this.getLevel().getBlockEntity(this.tube.getOtherEndPos(), (BlockEntityType)PetrolsPartsBlockEntityTypes.PNEUMATIC_TUBE.get());
    }

    protected Optional<Either<Input, Output>> getOtherHandler() {
        return this.getOther().flatMap(PneumaticTubeBlockEntity::getHandler);
    }

    public Optional<Input> asInput() {
        return this.getHandler().flatMap(PneumaticTubeBlockEntity::input);
    }

    public Optional<Output> asOutput() {
        return this.getHandler().flatMap(PneumaticTubeBlockEntity::output);
    }

    public boolean isInput() {
        return this.asInput().isPresent();
    }

    protected Optional<Input> setAsInput() {
        return this.asInput().or(() -> {
            this.handler = Optional.of(Either.left((Object)new Input()));
            return this.handler.get().left();
        });
    }

    public boolean isOutput() {
        return this.asOutput().isPresent();
    }

    protected Optional<Input> getInput() {
        return this.asInput().or(() -> this.getOtherHandler().flatMap(PneumaticTubeBlockEntity::input));
    }

    protected Optional<Output> getOutput() {
        return this.asOutput().or(() -> this.getOtherHandler().flatMap(PneumaticTubeBlockEntity::output));
    }

    public QueueItemHandler getItemBacklog() {
        return this.itemBacklog;
    }

    protected float getCombinedAbsSpeed() {
        return Math.abs(this.getSpeed()) + this.getOther().map(KineticBlockEntity::getSpeed).map(Math::abs).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void onFilterChanged(ItemStack filterStack) {
        this.resetInvVersionTracker();
        this.getOther().ifPresent(PneumaticTubeBlockEntity::resetInvVersionTracker);
    }

    public boolean supportsAmountOnFilter() {
        return ((PneumaticTubeBlock)this.getBlockState().getBlock()).filterable;
    }

    public void resetInvVersionTracker() {
        this.invVersionTracker.reset();
    }

    protected int getItemTransportDistance() {
        return 320 * (int)this.tube.getSplineOptional().map(ClampedCubicSpline::getLength).orElse(0.0).doubleValue();
    }

    public void tick() {
        super.tick();
        this.asInput().ifPresent(Input::tick);
        this.asOutput().ifPresent(Output::tick);
    }

    public void afterTubeConnect() {
        this.setAsInput();
        this.notifyUpdate();
        this.removeHandlerClient = false;
    }

    public void beforeTubeDisconnect() {
        this.asInput().ifPresent(Input::dropItems);
        this.handler = Optional.empty();
        this.removeHandlerClient = true;
    }

    public InteractionResult flip(@Nullable Player player) {
        return this.getInput().map(input -> {
            if (!input.getStacksTransporting().isEmpty()) {
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.petrolsparts.pneumatic_tube.cant_flip").withStyle(ChatFormatting.RED), true);
                }
                return InteractionResult.FAIL;
            }
            if (!this.getOutput().isPresent()) {
                return InteractionResult.FAIL;
            }
            this.getOutput().ifPresent(output -> {
                output.enclosing().setAsInput();
                output.enclosing().notifyUpdate();
            });
            input.enclosing().removeHandler().notifyUpdate();
            return InteractionResult.SUCCESS;
        }).orElse(InteractionResult.PASS);
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.getOutput().map(Output::enclosing).map(PneumaticTubeBlockEntity::getItemBacklog).map(h -> {
            if (h.isEmpty()) {
                return false;
            }
            CreateLang.builder().add(Component.translatable((String)"block.petrolsparts.pneumatic_tube.jammed")).style(ChatFormatting.GOLD).forGoggles(tooltip);
            TooltipHelper.cutTextComponent((Component)Component.translatable((String)"block.petrolsparts.pneumatic_tube.jammed.hint"), (FontHelper.Palette)FontHelper.Palette.GRAY_AND_WHITE).stream().map(Component::copy).map(arg_0 -> ((LangBuilder)CreateLang.builder()).add(arg_0)).forEach(lb -> lb.forGoggles(tooltip));
            return true;
        }).orElse(false) | super.addToTooltip(tooltip, isPlayerSneaking);
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.getInput().ifPresent(Input::updateFromSpeed);
        this.updateFromSpeedClient = true;
        this.notifyUpdate();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.itemBacklog.deserializeNBT(registries, compound.getList("Backlog", 10));
        if (compound.contains("Input", 10)) {
            this.setAsInput().ifPresent(input -> input.deserializeNBT(registries, compound.getCompound("Input")));
        }
        if (compound.contains("RemoveHandler")) {
            this.handler = Optional.empty();
            this.removeHandlerClient = false;
        }
        if (compound.contains("UpdateFromSpeed")) {
            this.getInput().ifPresent(Input::updateFromSpeed);
            this.updateFromSpeedClient = false;
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.put("Backlog", (Tag)this.itemBacklog.serializeNBT(registries));
        this.asInput().ifPresent(input -> compound.put("Input", (Tag)input.serializeNBT(registries)));
        if (clientPacket && this.removeHandlerClient) {
            compound.putBoolean("RemoveHandler", true);
            this.removeHandlerClient = false;
        }
        if (clientPacket && this.updateFromSpeedClient) {
            compound.putBoolean("UpdateFromSpeed", true);
            this.updateFromSpeedClient = false;
        }
    }

    public void invalidateTubeRenderBoundingBox() {
        this.invalidateRenderBoundingBox();
    }

    protected AABB createRenderBoundingBox() {
        if (!this.tube.isController() || this.tube.getSpline() == null) {
            return super.createRenderBoundingBox();
        }
        return MathsHelper.expandToInclude((AABB)this.tube.getSpline().getOccupiedVolume(), (BlockPos)this.getBlockPos());
    }

    public static Optional<Input> input(Either<Input, Output> handler) {
        return handler.left();
    }

    public static Optional<Output> output(Either<Input, Output> handler) {
        return handler.right();
    }

    protected class PneumaticTubeValueBoxTransform
    extends DeployerFilterSlot {
        protected PneumaticTubeValueBoxTransform(PneumaticTubeBlockEntity this$0) {
        }

        public Vec3 getLocalOffset(LevelAccessor level, BlockPos pos, BlockState state) {
            return super.getLocalOffset(level, pos, state).subtract(Vec3.atLowerCornerOf((Vec3i)((Direction)state.getValue((Property)PneumaticTubeBlock.FACING)).getNormal()).scale(0.1875));
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return ((Direction)state.getValue((Property)PneumaticTubeBlock.FACING)).getAxis() != direction.getAxis();
        }
    }

    public class Input
    implements INBTSerializable<CompoundTag> {
        public final Codec<StackTransporting> STACK_TRANSPORTING_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(StackTransporting::getStack), (App)Codec.INT.fieldOf("progress").forGetter(StackTransporting::getDistanceRemaining)).apply((Applicative)instance, (x$0, x$1) -> new StackTransporting((ItemStack)x$0, (int)x$1)));
        protected final Queue<StackTransporting> stacksTransporting = new LinkedList<StackTransporting>();
        protected int distanceMovedPerTick = -1;
        protected int inputCooldown = 1;

        protected Input() {
        }

        public PneumaticTubeBlockEntity enclosing() {
            return PneumaticTubeBlockEntity.this;
        }

        public Optional<Output> getOrCreateOutput() {
            return PneumaticTubeBlockEntity.this.getOther().flatMap(other -> {
                if (!other.handler.isPresent()) {
                    other.handler = Optional.of(Either.right((Object)(PneumaticTubeBlockEntity)((Object)other).new Output()));
                }
                return other.asOutput();
            });
        }

        public Collection<StackTransporting> getStacksTransporting() {
            return this.stacksTransporting;
        }

        public void tick() {
            this.getOrCreateOutput();
            if (this.distanceMovedPerTick == -1) {
                this.updateFromSpeed();
            }
            if (PneumaticTubeBlockEntity.this.getCombinedAbsSpeed() == 0.0f) {
                return;
            }
            boolean changed = !this.stacksTransporting.isEmpty();
            Iterator iterator = this.stacksTransporting.iterator();
            while (iterator.hasNext()) {
                StackTransporting stackTransporting = (StackTransporting)iterator.next();
                stackTransporting.tick();
                if (stackTransporting.distanceRemaining > 0) continue;
                iterator.remove();
                ItemStack stack = stackTransporting.getStack();
                if (stack.isEmpty()) continue;
                this.getOrCreateOutput().ifPresentOrElse(output -> output.outputOrBacklog(stack), () -> PneumaticTubeBlockEntity.this.itemBacklog.add(stack));
            }
            if (PneumaticTubeBlockEntity.this.getLevel().isClientSide()) {
                return;
            }
            ItemStack backloggedItem = PneumaticTubeBlockEntity.this.itemBacklog.pollStack();
            while (backloggedItem != null && !backloggedItem.isEmpty()) {
                changed = true;
                this.transport(backloggedItem);
                this.resetInputCooldown();
                backloggedItem = PneumaticTubeBlockEntity.this.itemBacklog.pollStack();
            }
            if (this.inputCooldown > 0) {
                --this.inputCooldown;
            }
            if (this.inputCooldown <= 0 && this.input()) {
                this.resetInputCooldown();
            }
            if (changed) {
                PneumaticTubeBlockEntity.this.setChanged();
            }
        }

        public boolean input() {
            if (!PneumaticTubeBlockEntity.this.itemBacklog.isEmpty()) {
                return true;
            }
            if (!this.getOrCreateOutput().map(Output::getItemBacklog).map(QueueItemHandler::isEmpty).orElse(false).booleanValue()) {
                return false;
            }
            if (PneumaticTubeBlockEntity.this.invVersionTracker.stillWaiting(PneumaticTubeBlockEntity.this.targetInventory)) {
                return false;
            }
            ItemStack toTryTransport = ((InvManipulationBehaviour)PneumaticTubeBlockEntity.this.targetInventory.simulate()).extract(this.getModeToExtract(), this.getAmountToExtract(), arg_0 -> ((FilteringBehaviour)PneumaticTubeBlockEntity.this.filtering).test(arg_0));
            if (toTryTransport.isEmpty()) {
                return false;
            }
            int remaining = this.getOrCreateOutput().map(output -> output.output(toTryTransport, true)).map(ItemStack::getCount).orElse(toTryTransport.getCount());
            if (toTryTransport.getCount() <= remaining) {
                return false;
            }
            ItemStack toTransport = PneumaticTubeBlockEntity.this.targetInventory.extract(ItemHelper.ExtractionCountMode.EXACTLY, toTryTransport.getCount() - remaining, arg_0 -> ((FilteringBehaviour)PneumaticTubeBlockEntity.this.filtering).test(arg_0));
            this.transport(toTransport);
            AllSoundEvents.FWOOMP.playAt(PneumaticTubeBlockEntity.this.level, (Vec3i)PneumaticTubeBlockEntity.this.getBlockPos(), 1.0f, 1.0f, true);
            return true;
        }

        protected void transport(ItemStack stack) {
            StackTransporting stackTransporting = new StackTransporting(stack, PneumaticTubeBlockEntity.this.getItemTransportDistance());
            this.stacksTransporting.add(stackTransporting);
            stackTransporting.updateAnimation();
            Level level = PneumaticTubeBlockEntity.this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(PneumaticTubeBlockEntity.this.getBlockPos()), (CustomPacketPayload)new PneumaticTubeItemTransportPacket(PneumaticTubeBlockEntity.this.getBlockPos(), stack));
            }
        }

        public Runnable transportAnimationOnly() {
            StackTransporting stackTransporting = new StackTransporting(ItemStack.EMPTY, PneumaticTubeBlockEntity.this.getItemTransportDistance());
            this.stacksTransporting.add(stackTransporting);
            return () -> this.stacksTransporting.remove(stackTransporting);
        }

        public ItemHelper.ExtractionCountMode getModeToExtract() {
            if (!PneumaticTubeBlockEntity.this.supportsAmountOnFilter() || !PneumaticTubeBlockEntity.this.filtering.isActive()) {
                return ItemHelper.ExtractionCountMode.UPTO;
            }
            return PneumaticTubeBlockEntity.this.targetInventory.getModeFromFilter();
        }

        public int getAmountToExtract() {
            if (!PneumaticTubeBlockEntity.this.supportsAmountOnFilter()) {
                return 64;
            }
            if (!PneumaticTubeBlockEntity.this.filtering.isActive()) {
                return 1;
            }
            return PneumaticTubeBlockEntity.this.targetInventory.getAmountFromFilter();
        }

        public void dropItems() {
            TubeSpline spline = PneumaticTubeBlockEntity.this.tube.getSplineOptional().orElse(null);
            if (spline == null) {
                this.stacksTransporting.stream().map(StackTransporting::getStack).forEach(s -> Block.popResource((Level)PneumaticTubeBlockEntity.this.getLevel(), (BlockPos)PneumaticTubeBlockEntity.this.getBlockPos(), (ItemStack)s));
            } else {
                List points = spline.getPoints();
                if (!points.isEmpty()) {
                    this.stacksTransporting.forEach(stackTransporting -> ItemHelper.pop((Level)PneumaticTubeBlockEntity.this.getLevel(), (Vec3)((Vec3)points.get(points.size() - 1 - points.size() * stackTransporting.getDistanceRemaining() / PneumaticTubeBlockEntity.this.getItemTransportDistance())), (ItemStack)stackTransporting.getStack()));
                }
            }
            this.stacksTransporting.clear();
        }

        public void updateFromSpeed() {
            this.distanceMovedPerTick = Math.max(1, (int)PneumaticTubeBlockEntity.this.getCombinedAbsSpeed());
            this.stacksTransporting.forEach(StackTransporting::updateAnimation);
        }

        protected void resetInputCooldown() {
            this.inputCooldown = (int)(PetrolsPartsConfigs.server().pneumaticTubeSpacing.getF() * 320.0f / (float)this.distanceMovedPerTick);
        }

        public CompoundTag serializeNBT(HolderLookup.Provider registries) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Cooldown", this.inputCooldown);
            tag.put("Items", (Tag)NBTHelper.writeCompoundList(this.stacksTransporting, s -> this.STACK_TRANSPORTING_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, s).result().orElse(null)));
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
            this.distanceMovedPerTick = -1;
            this.inputCooldown = nbt.getInt("Cooldown");
            this.stacksTransporting.clear();
            this.stacksTransporting.addAll(NBTHelper.readCompoundList((ListTag)nbt.getList("Items", 10), t -> this.STACK_TRANSPORTING_CODEC.parse((DynamicOps)NbtOps.INSTANCE, t).result().orElse(null)));
        }

        public class StackTransporting {
            protected final ItemStack stack;
            protected int distanceRemaining = 0;
            public final LerpedFloat animation = LerpedFloat.linear().startWithValue(0.0).chase(1.0, 0.0, LerpedFloat.Chaser.LINEAR);

            public StackTransporting(ItemStack stack, int distanceRemaining) {
                this.stack = stack;
                this.distanceRemaining = distanceRemaining;
                if (PneumaticTubeBlockEntity.this.getLevel() != null) {
                    this.updateAnimation();
                }
            }

            public ItemStack getStack() {
                return this.stack;
            }

            public int getDistanceRemaining() {
                return this.distanceRemaining;
            }

            public void updateAnimation() {
                this.animation.setValue((double)(1.0f - (float)this.distanceRemaining / (float)PneumaticTubeBlockEntity.this.getItemTransportDistance()));
                if (PneumaticTubeBlockEntity.this.getItemTransportDistance() == 0) {
                    this.animation.updateChaseSpeed(0.0);
                }
                this.animation.updateChaseSpeed((double)((float)Input.this.distanceMovedPerTick / (float)PneumaticTubeBlockEntity.this.getItemTransportDistance()));
            }

            public void tick() {
                this.distanceRemaining -= Input.this.distanceMovedPerTick;
                this.animation.tickChaser();
            }
        }
    }

    public class Output {
        protected Boolean blocked = null;
        protected WeakReference<Entity> lastBlockingEntityRef = null;

        public PneumaticTubeBlockEntity enclosing() {
            return PneumaticTubeBlockEntity.this;
        }

        public Optional<Input> getInput() {
            return PneumaticTubeBlockEntity.this.getOtherHandler().flatMap(PneumaticTubeBlockEntity::input);
        }

        public Direction getOutputFace() {
            return ((Direction)PneumaticTubeBlockEntity.this.getBlockState().getValue((Property)PneumaticTubeBlock.FACING)).getOpposite();
        }

        public Vec3 getOutputLocation() {
            Direction outputFace = this.getOutputFace();
            return BlockFace.of((BlockPos)PneumaticTubeBlockEntity.this.getBlockPos(), (Direction)outputFace).getCenter().relative(outputFace, 0.03125);
        }

        public void forgetBlocked() {
            this.blocked = null;
        }

        public boolean isBlocked() {
            if (this.blocked == null) {
                BlockPos outputPos = PneumaticTubeBlockEntity.this.getBlockPos().relative(this.getOutputFace());
                BlockHitResult blockHit = PneumaticTubeBlockEntity.this.level.clip(new ClipContext(this.getOutputLocation(), Vec3.atCenterOf((Vec3i)outputPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                this.blocked = blockHit.getType() == HitResult.Type.BLOCK && blockHit.getBlockPos().equals((Object)outputPos);
            }
            return this.blocked;
        }

        public void tick() {
            ItemStack stack = PneumaticTubeBlockEntity.this.itemBacklog.pollStack();
            if (!stack.isEmpty()) {
                PneumaticTubeBlockEntity.this.itemBacklog.add(this.output(stack, false));
            }
        }

        protected ItemStack output(ItemStack stack, boolean simulate) {
            ItemStack remainder;
            Direction outputFace = this.getOutputFace();
            BlockPos outputPos = PneumaticTubeBlockEntity.this.getBlockPos().relative(outputFace);
            if (simulate) {
                PneumaticTubeBlockEntity.this.targetInventory.simulate();
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)(remainder = PneumaticTubeBlockEntity.this.targetInventory.insert(stack)))) {
                PneumaticTubeBlockEntity.this.advancements.awardAdvancement(PetrolsPartsAdvancementTriggers.PNEUMATIC_TUBE);
                return remainder;
            }
            if (PneumaticTubeBlockEntity.this.targetInventory.hasInventory()) {
                return stack;
            }
            float speed = PneumaticTubeBlockEntity.this.getCombinedAbsSpeed();
            if (this.isBlocked() || speed == 0.0f) {
                return stack;
            }
            boolean blockingEntityPresent = true;
            AABB blockingArea = new AABB(outputPos);
            if (this.lastBlockingEntityRef == null) {
                blockingEntityPresent = false;
            } else {
                Object lastBlockingEntity = (Entity)this.lastBlockingEntityRef.get();
                if (lastBlockingEntity == null || !lastBlockingEntity.isAlive() || !lastBlockingEntity.getBoundingBox().intersects(blockingArea)) {
                    blockingEntityPresent = false;
                    lastBlockingEntity = null;
                }
            }
            if (blockingEntityPresent) {
                return stack;
            }
            for (Entity entity : PneumaticTubeBlockEntity.this.level.getEntities(null, blockingArea)) {
                if (!(entity instanceof ItemEntity) && !(entity instanceof PackageEntity)) continue;
                this.lastBlockingEntityRef = new WeakReference<Entity>(entity);
                return stack;
            }
            if (!simulate) {
                Vec3 outputLoc = this.getOutputLocation();
                ItemEntity itemEntity = new ItemEntity(PneumaticTubeBlockEntity.this.level, outputLoc.x(), outputLoc.y(), outputLoc.z(), stack);
                itemEntity.setDefaultPickUpDelay();
                itemEntity.setDeltaMovement(new Vec3(outputFace.step()).scale(0.25 * Math.pow(speed, 0.25)));
                PneumaticTubeBlockEntity.this.level.addFreshEntity((Entity)itemEntity);
                this.lastBlockingEntityRef = new WeakReference<ItemEntity>(itemEntity);
                PneumaticTubeBlockEntity.this.advancements.awardAdvancement(PetrolsPartsAdvancementTriggers.PNEUMATIC_TUBE);
            }
            return ItemStack.EMPTY;
        }

        protected void outputOrBacklog(ItemStack stack) {
            ItemStack remainder = this.output(stack, false);
            if (!remainder.isEmpty()) {
                PneumaticTubeBlockEntity.this.itemBacklog.add(stack);
            }
        }

        protected QueueItemHandler getItemBacklog() {
            return PneumaticTubeBlockEntity.this.getItemBacklog();
        }
    }
}

