/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.pneumatic_tube;

import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeBlockEntity;
import java.util.Optional;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.instruction.PonderInstruction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PneumaticTubeTransportInstruction
extends PonderInstruction {
    public final BlockPos pos;
    public final boolean blocking;
    protected int ticksRemaining = -1;
    protected Runnable removeCallback = () -> {};

    public PneumaticTubeTransportInstruction(BlockPos tubeInputPos, boolean blocking) {
        this.pos = tubeInputPos;
        this.blocking = blocking;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isComplete() {
        return this.ticksRemaining == 0;
    }

    public void onScheduled(PonderScene scene) {
        super.onScheduled(scene);
        if (this.isBlocking()) {
            scene.addToSceneTime(this.getDuration(scene));
        }
    }

    public void tick(PonderScene scene) {
        if (this.ticksRemaining == -1) {
            this.ticksRemaining = this.getDuration(scene);
            this.removeCallback = this.getInput(scene).map(PneumaticTubeBlockEntity.Input::transportAnimationOnly).orElse(() -> {});
        }
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
        }
    }

    public void reset(PonderScene scene) {
        super.reset(scene);
        this.ticksRemaining = -1;
        this.removeCallback.run();
    }

    public Optional<PneumaticTubeBlockEntity.Input> getInput(PonderScene scene) {
        BlockEntity blockEntity = scene.getWorld().getBlockEntity(this.pos);
        if (blockEntity instanceof PneumaticTubeBlockEntity) {
            PneumaticTubeBlockEntity tube = (PneumaticTubeBlockEntity)blockEntity;
            return tube.asInput();
        }
        return Optional.empty();
    }

    protected int getDuration(PonderScene scene) {
        return this.getInput(scene).map(input -> {
            input.updateFromSpeed();
            return input.enclosing().getItemTransportDistance() / input.distanceMovedPerTick;
        }).orElse(0);
    }
}

