/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.core.advancement;

import com.petrolpark.petrolsparts.PetrolsParts;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTrigger;
import com.petrolpark.util.Lang;
import java.util.stream.Stream;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public enum PetrolsPartsAdvancementTriggers {
    COAXIAL_GEAR,
    COLOSSAL_COGWHEEL_POWER_MANY,
    DIFFERENTIAL,
    PNEUMATIC_TUBE;

    private final String triggerId = Lang.asId((String)this.name());
    private final String[] advancementIds = new String[]{Lang.asId((String)this.name())};
    private final PetrolsPartsAdvancementTrigger trigger = new PetrolsPartsAdvancementTrigger();

    public void award(Level level, Player player) {
        if (level.isClientSide()) {
            return;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.trigger.trigger(serverPlayer);
        } else {
            PetrolsParts.LOGGER.warn("Could not award Destroy Advancement " + this.triggerId + " to client-side Player.");
        }
    }

    public boolean isAlreadyAwardedTo(LivingEntity player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        for (String advancementId : this.advancementIds) {
            AdvancementHolder advancement = sp.getServer().getAdvancements().get(PetrolsParts.asResource(advancementId));
            if (advancement != null && !sp.getAdvancements().getOrStartProgress(advancement).isDone()) continue;
            return true;
        }
        return false;
    }

    public static void register() {
        Stream.of(PetrolsPartsAdvancementTriggers.values()).forEach(trigger -> Registry.register((Registry)BuiltInRegistries.TRIGGER_TYPES, (ResourceLocation)PetrolsParts.asResource(trigger.triggerId), (Object)((Object)trigger.trigger)));
    }
}

