/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.Petrolpark;
import com.petrolpark.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber
public enum PetrolparkFeatureFlags {
    EXTENDED_INVENTORY;

    public final FeatureFlag featureFlag = FeatureFlags.REGISTRY.getFlag(Petrolpark.asResource(Lang.asId(this.name())));

    public boolean isEnabled() {
        return this.isEnabled(PetrolparkFeatureFlags.getEnabledFeatures());
    }

    public boolean isEnabled(FeatureFlagSet flagSet) {
        return flagSet.contains(this.featureFlag);
    }

    public static FeatureFlagSet getEnabledFeatures() {
        return (FeatureFlagSet)Petrolpark.runForDist(() -> () -> ((ClientPacketListener)Minecraft.getInstance().getConnection()).enabledFeatures(), () -> () -> ((WorldData)ServerLifecycleHooks.getCurrentServer().getWorldData()).enabledFeatures());
    }

    public static boolean isEnabled(FeatureFlag flag) {
        return PetrolparkFeatureFlags.getEnabledFeatures().contains(flag);
    }

    @SubscribeEvent
    public static final void onAddPackFinders(AddPackFindersEvent event) {
        for (PetrolparkFeatureFlags flag : PetrolparkFeatureFlags.values()) {
            String id = Lang.asId(flag.name());
            event.addPackFinders(Petrolpark.asResource("data/petrolpark/datapack/experimental/" + id), PackType.SERVER_DATA, (Component)Component.translatable((String)("petrolpark.dataPack." + id + ".name")), PackSource.FEATURE, false, Pack.Position.TOP);
        }
    }
}

