/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark;

import com.petrolpark.Petrolpark;
import com.petrolpark.compat.Mods;
import com.petrolpark.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="petrolpark")
public class PetrolparkRemaps {
    private static final List<Pair<ResourceLocation, ResourceLocation>> BLOCKS = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
    private static final List<Pair<ResourceLocation, ResourceLocation>> BLOCK_ENTITY_TYPES = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();
    private static final List<Pair<ResourceLocation, ResourceLocation>> ITEMS = new ArrayList<Pair<ResourceLocation, ResourceLocation>>();

    private static final void item(ResourceLocation oldRL, String newName) {
        ITEMS.add(Pair.of(oldRL, Petrolpark.asResource(newName)));
    }

    private static final void destroyItem(String name) {
        PetrolparkRemaps.item(Mods.DESTROY.asResource(name), name);
    }

    private static final void block(ResourceLocation oldRL, String newName) {
        BLOCKS.add(Pair.of(oldRL, Petrolpark.asResource(newName)));
    }

    private static final void destroyBlock(String name) {
        PetrolparkRemaps.block(Mods.DESTROY.asResource(name), name);
    }

    private static final void blockEntityType(ResourceLocation oldRL, String newName) {
        BLOCK_ENTITY_TYPES.add(Pair.of(oldRL, Petrolpark.asResource(newName)));
    }

    private static final void destroyBlockEntityType(String name) {
        PetrolparkRemaps.blockEntityType(Mods.DESTROY.asResource(name), name);
    }

    private static final void destroyBlockAndItem(String name) {
        PetrolparkRemaps.destroyItem(name);
        PetrolparkRemaps.destroyBlock(name);
    }

    private static final void destroyBlockEntityAndItem(String name) {
        PetrolparkRemaps.destroyItem(name);
        PetrolparkRemaps.destroyBlock(name);
        PetrolparkRemaps.destroyBlockEntityType(name);
    }

    @SubscribeEvent
    public static final void onRegister(RegisterEvent event) {
        List<Pair<ResourceLocation, ResourceLocation>> remaps;
        Registry registry = event.getRegistry();
        ResourceKey key = registry.key();
        if (key == Registries.BLOCK) {
            remaps = BLOCKS;
        } else if (key == Registries.ITEM) {
            remaps = ITEMS;
        } else {
            return;
        }
        remaps.forEach(pair -> registry.addAlias((ResourceLocation)pair.getFirst(), (ResourceLocation)pair.getSecond()));
    }

    static {
        PetrolparkRemaps.destroyItem("butter");
        PetrolparkRemaps.destroyItem("mashed_potato");
        PetrolparkRemaps.destroyItem("mesh");
        PetrolparkRemaps.destroyBlockAndItem("mashed_potato_block");
        PetrolparkRemaps.destroyBlockEntityAndItem("extrusion_die");
        PetrolparkRemaps.destroyBlockEntityAndItem("redstone_programmer");
    }
}

