/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.client.sprite;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public abstract class WrappedSpriteSource
implements SpriteSource {
    private final SpriteSource wrappedSource;
    private final String prefix;
    private final Optional<List<String>> allowedNamespaces;

    public WrappedSpriteSource(SpriteSource wrappedSource, String prefix, Optional<List<String>> allowedNamespaces) {
        this.wrappedSource = wrappedSource;
        this.prefix = prefix;
        this.allowedNamespaces = allowedNamespaces;
    }

    public SpriteSource getWrappedSource() {
        return this.wrappedSource;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Optional<List<String>> getAllowedNamespaces() {
        return this.allowedNamespaces;
    }

    public void run(@Nonnull ResourceManager resourceManager, final @Nonnull SpriteSource.Output output) {
        final SpriteResourceLoader resourceLoader = this.createSpriteResourceLoader();
        SpriteSource.Output wrappedOutput = new SpriteSource.Output(){

            public void add(@Nonnull ResourceLocation location, @Nonnull SpriteSource.SpriteSupplier sprite) {
                if (WrappedSpriteSource.this.allowedNamespaces.isPresent() && !WrappedSpriteSource.this.allowedNamespaces.get().contains(location.getNamespace())) {
                    return;
                }
                output.add(location.withPrefix(WrappedSpriteSource.this.prefix), WrappedSpriteSource.this.transform((SpriteContents)sprite.apply((Object)resourceLoader)));
            }

            public void removeAll(@Nonnull Predicate<ResourceLocation> predicate) {
                output.removeAll(predicate);
            }
        };
        this.wrappedSource.run(resourceManager, wrappedOutput);
    }

    public SpriteResourceLoader createSpriteResourceLoader() {
        return SpriteResourceLoader.create((Collection)SpriteLoader.DEFAULT_METADATA_SECTIONS);
    }

    public abstract SpriteSource.SpriteSupplier transform(SpriteContents var1);
}

