/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.common.mobeffect;

import com.petrolpark.common.mobeffect.SimpleMobEffect;
import java.util.ArrayList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundRemoveMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.chunk.ChunkSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@EventBusSubscriber
public class SyncedMobEffect
extends SimpleMobEffect {
    public SyncedMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    @SubscribeEvent
    public static final void onEffectAdded(MobEffectEvent.Added event) {
        ChunkSource chunkSource;
        if (event.getEffectInstance().getEffect().value() instanceof SyncedMobEffect && (chunkSource = event.getEntity().level().getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.broadcast((Entity)event.getEntity(), (Packet)new ClientboundUpdateMobEffectPacket(event.getEntity().getId(), event.getEffectInstance(), false));
        }
    }

    @SubscribeEvent
    public static final void onEffectRemoved(MobEffectEvent.Remove event) {
        ChunkSource chunkSource;
        if (event.getEffect().value() instanceof SyncedMobEffect && (chunkSource = event.getEntity().level().getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.broadcast((Entity)event.getEntity(), (Packet)new ClientboundRemoveMobEffectPacket(event.getEntity().getId(), event.getEffect()));
        }
    }

    @SubscribeEvent
    public static final void onStartTrackingEntity(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ArrayList<ClientboundUpdateMobEffectPacket> packets = new ArrayList<ClientboundUpdateMobEffectPacket>();
                for (MobEffectInstance effectInstance : entity2.getActiveEffects()) {
                    if (!(effectInstance.getEffect().value() instanceof SyncedMobEffect)) continue;
                    packets.add(new ClientboundUpdateMobEffectPacket(entity2.getId(), effectInstance, false));
                }
                if (packets.size() == 1) {
                    player.connection.send((Packet)packets.get(0));
                } else if (packets.size() > 0) {
                    player.connection.send((Packet)new ClientboundBundlePacket(packets));
                }
            }
        }
    }
}

