/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.common.particle;

import com.petrolpark.PetrolparkParticleTypes;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class AirBubbleParticle
extends TextureSheetParticle {
    public static final int POP_TIME = 4;
    protected final SpriteSet spriteSet;

    protected AirBubbleParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.setSize(0.02f, 0.02f);
        this.quadSize *= this.random.nextFloat() * 0.6f + 0.2f;
        this.xd = xSpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.yd = ySpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.zd = zSpeed * (double)0.2f + (Math.random() * 2.0 - 1.0) * (double)0.02f;
        this.lifetime = (int)(40.0 / (Math.random() * 0.8 + 0.2));
        this.setSprite(spriteSet.get(0, this.lifetime));
    }

    public void tick() {
        super.tick();
        if (!this.removed && this.age + 4 >= this.lifetime) {
            this.setSprite(this.spriteSet.get(this.age + 4 - this.lifetime, 4));
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    @SubscribeEvent
    public static final void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)PetrolparkParticleTypes.AIR_BUBBLE.get(), Provider::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet sprites) {
            this.spriteSet = sprites;
        }

        public Particle createParticle(@Nonnull SimpleParticleType type, @Nonnull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AirBubbleParticle particle = new AirBubbleParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return particle;
        }
    }
}

