/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.Petrolpark;
import com.simibubi.create.foundation.gui.AllIcons;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class PetrolparkIcon
extends AllIcons {
    public static final ResourceLocation ICON_ATLAS = Petrolpark.asResource("textures/gui/icons.png");
    private static int x = 0;
    private static int y = -1;
    private final int iconX;
    private final int iconY;
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_MANUAL = PetrolparkIcon.newRow();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_SWITCH_ON_PULSE = PetrolparkIcon.next();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_RESTART_ON_PULSE = PetrolparkIcon.next();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_RESUME_WITH_POWER = PetrolparkIcon.next();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_RESTART_WITH_POWER = PetrolparkIcon.next();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_LOOP_WITH_POWER = PetrolparkIcon.next();
    public static final PetrolparkIcon REDSTONE_PROGRAMMER_MODE_LOOP = PetrolparkIcon.next();

    public PetrolparkIcon(int x, int y) {
        super(x, y);
        this.iconX = x * 16;
        this.iconY = y * 16;
    }

    private static PetrolparkIcon next() {
        return new PetrolparkIcon(++x, y);
    }

    private static PetrolparkIcon newRow() {
        x = 0;
        return new PetrolparkIcon(0, ++y);
    }

    protected ResourceLocation getTextureLocation() {
        return ICON_ATLAS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bind() {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTextureLocation());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics graphics, int x, int y) {
        graphics.blit(this.getTextureLocation(), x, y, 0, (float)this.iconX, (float)this.iconY, 16, 16, 256, 256);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack ms, MultiBufferSource buffer, int color) {
        VertexConsumer builder = buffer.getBuffer(RenderType.text((ResourceLocation)this.getTextureLocation()));
        Matrix4f matrix = ms.last().pose();
        Color rgb = new Color(color);
        int light = 0xF000F0;
        Vec3 vec1 = new Vec3(0.0, 0.0, 0.0);
        Vec3 vec2 = new Vec3(0.0, 1.0, 0.0);
        Vec3 vec3 = new Vec3(1.0, 1.0, 0.0);
        Vec3 vec4 = new Vec3(1.0, 0.0, 0.0);
        float u1 = (float)this.iconX * 1.0f / 256.0f;
        float u2 = (float)(this.iconX + 16) * 1.0f / 256.0f;
        float v1 = (float)this.iconY * 1.0f / 256.0f;
        float v2 = (float)(this.iconY + 16) * 1.0f / 256.0f;
        this.vertex(builder, matrix, vec1, rgb, u1, v1, light);
        this.vertex(builder, matrix, vec2, rgb, u1, v2, light);
        this.vertex(builder, matrix, vec3, rgb, u2, v2, light);
        this.vertex(builder, matrix, vec4, rgb, u2, v1, light);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void vertex(VertexConsumer builder, Matrix4f matrix, Vec3 vec, Color rgb, float u, float v, int light) {
        builder.addVertex(matrix, (float)vec.x, (float)vec.y, (float)vec.z).setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), 255).setUv(u, v).setLight(light);
    }
}

