/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.mandrel;

import com.petrolpark.compat.SharedFeatureFlag;
import com.petrolpark.compat.create.CreateBlockEntityTypes;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.common.processing.mandrel.MandrelRecipe;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;

public class MandrelBlockEntity
extends KineticBlockEntity {
    public final ItemStackHandler inputInv = new ItemStackHandler(1);
    public final ItemStackHandler outputInv = new ItemStackHandler(1);
    public final IItemHandler capability = new InventoryHandler();
    public int timer = 100;
    protected MandrelRecipe lastRecipe = null;
    public boolean running = false;
    protected float animationStartPartialTick = 0.0f;

    public MandrelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        if (SharedFeatureFlag.MANDREL.enabled()) {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CreateBlockEntityTypes.MANDREL.get(), (be, context) -> be.capability);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this));
        super.addBehaviours(behaviours);
    }

    public void tick() {
        super.tick();
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.timer > 0) {
            --this.timer;
            if (level.isClientSide()) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(this.inputInv.getStackInSlot(0));
        if (this.lastRecipe == null || !this.lastRecipe.matches(recipeInput, level)) {
            Optional recipe = level.getRecipeManager().getRecipeFor(CreateRecipeTypes.MANDREL.getType(), (RecipeInput)recipeInput, level);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (MandrelRecipe)((RecipeHolder)recipe.get()).value();
                this.startProcessing();
                this.sendData();
            }
            return;
        }
        this.startProcessing();
        this.sendData();
    }

    public void startProcessing() {
        if (this.lastRecipe == null) {
            return;
        }
        this.timer = (int)((2.0f + this.lastRecipe.animation().getTotalAngleSubtended(this) / 360.0f) / (this.getSpeed() / 1200.0f));
        this.running = true;
        this.sendData();
        CatnipServices.PLATFORM.executeOnClientOnly(() -> this::logAnimationStartTime);
    }

    public void resetProcessing() {
        this.running = false;
        this.timer = 100;
    }

    public void spawnParticles() {
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.getLevel(), (BlockPos)this.getBlockPos(), (IItemHandler)this.outputInv);
    }

    public void process() {
        this.running = false;
        SingleRecipeInput inventoryIn = new SingleRecipeInput(this.inputInv.getStackInSlot(0));
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, level)) {
            Optional recipe = level.getRecipeManager().getRecipeFor(CreateRecipeTypes.MANDREL.getType(), (RecipeInput)inventoryIn, level);
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = (MandrelRecipe)((RecipeHolder)recipe.get()).value();
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.shrink(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)this.lastRecipe.result().copy(), (boolean)false);
        this.sendData();
        this.setChanged();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void logAnimationStartTime() {
        this.animationStartPartialTick = AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
    }

    protected boolean canProcess(ItemStack stack) {
        Level level = this.getLevel();
        if (level == null) {
            return false;
        }
        SingleRecipeInput input = new SingleRecipeInput(stack);
        if (this.lastRecipe != null && this.lastRecipe.matches(input, level)) {
            return true;
        }
        return level.getRecipeManager().getRecipeFor(CreateRecipeTypes.MANDREL.getType(), (RecipeInput)input, level).isPresent();
    }

    public void onSpeedChanged(float previousSpeed) {
        super.onSpeedChanged(previousSpeed);
        this.resetProcessing();
    }

    protected class InventoryHandler
    extends CombinedInvWrapper {
        public InventoryHandler() {
            super(new IItemHandlerModifiable[]{MandrelBlockEntity.this.inputInv, MandrelBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (MandrelBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return MandrelBlockEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (MandrelBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (MandrelBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

