/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.processing.mandrel;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.CreateRecipeTypes;
import com.petrolpark.compat.create.common.processing.mandrel.animation.IMandrelAnimation;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record MandrelRecipe(Ingredient ingredient, ItemStack result, IMandrelAnimation animation) implements Recipe<SingleRecipeInput>
{
    public static final MapCodec<MandrelRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(MandrelRecipe::ingredient), (App)ItemStack.CODEC.fieldOf("result").forGetter(MandrelRecipe::result), (App)IMandrelAnimation.CODEC.fieldOf("animation").forGetter(MandrelRecipe::animation)).apply((Applicative)instance, MandrelRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MandrelRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, MandrelRecipe::ingredient, (StreamCodec)ItemStack.STREAM_CODEC, MandrelRecipe::result, IMandrelAnimation.STREAM_CODEC, MandrelRecipe::animation, MandrelRecipe::new);

    public boolean matches(@Nonnull SingleRecipeInput input, @Nonnull Level level) {
        return this.ingredient().test(input.item());
    }

    public ItemStack assemble(@Nonnull SingleRecipeInput input, @Nonnull HolderLookup.Provider registries) {
        return this.result();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return this.result();
    }

    public RecipeSerializer<MandrelRecipe> getSerializer() {
        return CreateRecipeTypes.MANDREL.getSerializer();
    }

    public RecipeType<MandrelRecipe> getType() {
        return CreateRecipeTypes.MANDREL.getType();
    }

    public static class Serializer
    implements RecipeSerializer<MandrelRecipe> {
        public MapCodec<MandrelRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MandrelRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

