/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.compat.create.CreateBlocks;
import com.petrolpark.compat.create.PetrolparkIcon;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerMenu;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.link.IRedstoneLinkable;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.createmod.catnip.data.Couple;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public abstract class RedstoneProgram {
    public static final StreamEncoder<RegistryFriendlyByteBuf, RedstoneProgram> ENCODER = RedstoneProgram.streamCodec(RedstoneProgrammerMenu.DummyRedstoneProgram::new);
    public PlayMode mode;
    protected int length;
    protected int playtime;
    protected int ticksToNextBeat;
    public boolean paused;
    protected boolean pausedLastTick;
    protected boolean poweredLastTick;
    protected List<Channel> channels;
    protected int ticksPerBeat;
    public int beatsPerLine;
    public int linesPerBar;
    protected boolean notifiedChange;

    public static final <PROGRAM extends RedstoneProgram> Codec<PROGRAM> codec(Factory<PROGRAM> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)PlayMode.CODEC.optionalFieldOf("mode", (Object)PlayMode.MANUAL).forGetter(RedstoneProgram::getMode), (App)CodecHelper.POS_INT.optionalFieldOf("length", (Object)20).forGetter(RedstoneProgram::getLength), (App)CodecHelper.POS_INT.optionalFieldOf("playtime", (Object)0).forGetter(RedstoneProgram::getPlaytime), (App)CodecHelper.POS_INT.optionalFieldOf("ticks_to_next_beat", (Object)2).forGetter(RedstoneProgram::getTicksToNextBeat), (App)Codec.BOOL.optionalFieldOf("paused", (Object)true).forGetter(RedstoneProgram::isPaused), (App)Codec.BOOL.optionalFieldOf("was_paused", (Object)false).forGetter(RedstoneProgram::wasPausedLastTick), (App)Codec.BOOL.optionalFieldOf("was_powered", (Object)false).forGetter(RedstoneProgram::wasPoweredLastTick), (App)Codec.list(ChannelData.CODEC).optionalFieldOf("channels", Collections.emptyList()).forGetter(RedstoneProgram::getChannelData), (App)CodecHelper.POS_INT.optionalFieldOf("ticks_per_beat", (Object)2).forGetter(RedstoneProgram::getTicksPerBeat), (App)CodecHelper.POS_INT.optionalFieldOf("beats_per_line", (Object)2).forGetter(RedstoneProgram::getBeatsPerLine), (App)CodecHelper.POS_INT.optionalFieldOf("lines_per_bar", (Object)4).forGetter(RedstoneProgram::getLinesPerBar)).apply((Applicative)instance, factory::create));
    }

    public static final <PROGRAM extends RedstoneProgram> StreamCodec<RegistryFriendlyByteBuf, PROGRAM> streamCodec(Factory<PROGRAM> factory) {
        return CodecHelper.compositeStreamCodec(CatnipStreamCodecBuilders.ofEnum(PlayMode.class), RedstoneProgram::getMode, ByteBufCodecs.INT, RedstoneProgram::getLength, ByteBufCodecs.INT, RedstoneProgram::getPlaytime, ByteBufCodecs.INT, RedstoneProgram::getTicksToNextBeat, ByteBufCodecs.BOOL, RedstoneProgram::isPaused, ByteBufCodecs.BOOL, RedstoneProgram::wasPausedLastTick, ByteBufCodecs.BOOL, RedstoneProgram::wasPoweredLastTick, ChannelData.STREAM_CODEC.apply(ByteBufCodecs.list()), RedstoneProgram::getChannelData, ByteBufCodecs.INT, RedstoneProgram::getTicksPerBeat, ByteBufCodecs.INT, RedstoneProgram::getBeatsPerLine, ByteBufCodecs.INT, RedstoneProgram::getLinesPerBar, factory::create);
    }

    public RedstoneProgram(PlayMode mode, int length, int playtime, int ticksToNextBeat, boolean paused, boolean pausedLastTick, boolean poweredLastTick, List<ChannelData> channels, int ticksPerBeat, int beatsPerLine, int linesPerBar) {
        this.copyFrom(mode, length, playtime, ticksToNextBeat, paused, pausedLastTick, poweredLastTick, channels, ticksPerBeat, beatsPerLine, linesPerBar);
    }

    public RedstoneProgram() {
        this.mode = PlayMode.MANUAL;
        this.ticksPerBeat = (Integer)PetrolparkConfigs.server().redstoneProgrammerMinTicksPerBeat.get();
        this.length = 20;
        this.playtime = 0;
        this.ticksToNextBeat = this.ticksPerBeat;
        this.paused = true;
        this.pausedLastTick = false;
        this.poweredLastTick = false;
        this.channels = new ArrayList<Channel>();
        this.beatsPerLine = 2;
        this.linesPerBar = 4;
        this.notifiedChange = false;
    }

    public PlayMode getMode() {
        return this.mode;
    }

    public int getLength() {
        return this.length;
    }

    public int getPlaytime() {
        return this.playtime;
    }

    public int getTicksToNextBeat() {
        return this.ticksToNextBeat;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean wasPausedLastTick() {
        return this.pausedLastTick;
    }

    public boolean wasPoweredLastTick() {
        return this.poweredLastTick;
    }

    public List<ChannelData> getChannelData() {
        return this.getChannels().stream().map(Channel::asData).toList();
    }

    public int getTicksPerBeat() {
        return this.ticksPerBeat;
    }

    public int getBeatsPerLine() {
        return this.beatsPerLine;
    }

    public int getLinesPerBar() {
        return this.linesPerBar;
    }

    public int getAbsolutePlaytime() {
        return this.getTicksPerBeat() * this.getPlaytime() + (this.getTicksPerBeat() - this.getTicksToNextBeat());
    }

    public void setTicksPerBeat(int value) {
        this.ticksPerBeat = Math.max((Integer)PetrolparkConfigs.server().redstoneProgrammerMinTicksPerBeat.get(), value);
    }

    public void tick() {
        boolean powered = this.hasPower();
        if (this.mode.powerRequired) {
            boolean bl = this.paused = !powered;
        }
        if (powered && !this.poweredLastTick) {
            if (this.mode == PlayMode.SWITCH_ON_PULSE) {
                this.paused = !this.paused;
            } else if (this.mode == PlayMode.RESTART_ON_PULSE) {
                this.paused = false;
                this.playtime = 0;
            }
        }
        if (!powered && this.mode == PlayMode.LOOP_WITH_POWER) {
            this.playtime = 0;
        }
        if (!this.paused) {
            this.notifiedChange = false;
            if (this.ticksPerBeat == 1) {
                ++this.playtime;
            } else {
                --this.ticksToNextBeat;
                if (this.ticksToNextBeat <= 0) {
                    this.ticksToNextBeat = this.ticksPerBeat;
                    ++this.playtime;
                } else {
                    this.notifiedChange = true;
                }
            }
        }
        if (this.paused != this.pausedLastTick) {
            this.notifiedChange = false;
        }
        if (this.playtime >= this.length) {
            this.playtime = 0;
            if (this.mode.pausesWhenFinished) {
                this.paused = true;
            }
        }
        if (!this.notifiedChange) {
            this.channels.forEach(Channel::updateNetwork);
            if (this.paused) {
                this.notifiedChange = true;
            }
        }
        this.poweredLastTick = powered;
        this.pausedLastTick = this.paused;
    }

    public void restart() {
        this.playtime = 0;
        this.ticksToNextBeat = this.ticksPerBeat;
    }

    public abstract boolean hasPower();

    public abstract BlockPos getBlockPos();

    public abstract boolean shouldTransmit();

    public abstract LevelAccessor getWorld();

    public void whenChanged() {
    }

    public Object getHashSalt() {
        return 0;
    }

    public ImmutableList<Channel> getChannels() {
        return ImmutableList.copyOf(this.channels);
    }

    public void addBlankChannel(Couple<RedstoneLinkNetworkHandler.Frequency> frequencies) {
        Channel channel = new Channel(frequencies, new int[this.length]);
        this.channels.add(channel);
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return;
        }
        RedstoneProgram.getHandler().addToNetwork(this.getWorld(), (IRedstoneLinkable)channel);
    }

    public boolean remove(Channel channel) {
        boolean removed = this.channels.remove(channel);
        if (removed && RedstoneProgram.isValidWorld(this.getWorld())) {
            RedstoneProgram.getHandler().removeFromNetwork(this.getWorld(), (IRedstoneLinkable)channel);
        }
        return removed;
    }

    public void swap(Channel channel1, Channel channel2) {
        if (this.channels.contains(channel1) && this.channels.contains(channel2)) {
            Collections.swap(this.channels, this.channels.indexOf(channel1), this.channels.indexOf(channel2));
        }
    }

    public void load() {
        if (!RedstoneProgram.isValidWorld(this.getWorld()) || this.getBlockPos() == null) {
            return;
        }
        this.channels.forEach(channel -> RedstoneProgram.getHandler().addToNetwork(this.getWorld(), (IRedstoneLinkable)channel));
        this.notifiedChange = false;
    }

    public void unload() {
        if (!RedstoneProgram.isValidWorld(this.getWorld())) {
            return;
        }
        this.channels.forEach(channel -> RedstoneProgram.getHandler().removeFromNetwork(this.getWorld(), (IRedstoneLinkable)channel));
    }

    public void setDuration(int duration) {
        this.length = duration;
        for (Channel channel : this.channels) {
            channel.sequence = Arrays.copyOf(channel.sequence, duration);
        }
    }

    public RedstoneProgram copyFrom(PlayMode mode, int length, int playtime, int ticksToNextBeat, boolean paused, boolean pausedLastTick, boolean poweredLastTick, List<ChannelData> channels, int ticksPerBeat, int beatsPerLine, int linesPerBar) {
        this.mode = mode;
        this.length = length;
        this.playtime = playtime;
        this.ticksToNextBeat = ticksToNextBeat;
        this.paused = paused;
        this.pausedLastTick = pausedLastTick;
        this.poweredLastTick = poweredLastTick;
        this.channels = channels.stream().map(x$0 -> new Channel((ChannelData)x$0)).collect(Collectors.toCollection(ArrayList::new));
        this.ticksPerBeat = ticksPerBeat;
        this.beatsPerLine = beatsPerLine;
        this.linesPerBar = linesPerBar;
        this.notifiedChange = false;
        return this;
    }

    public RedstoneProgram copyFrom(RedstoneProgram otherProgram) {
        return this.copyFrom(otherProgram.getMode(), otherProgram.getLength(), otherProgram.getPlaytime(), otherProgram.getTicksToNextBeat(), otherProgram.isPaused(), otherProgram.wasPausedLastTick(), otherProgram.wasPoweredLastTick(), otherProgram.getChannelData(), otherProgram.getTicksPerBeat(), otherProgram.getBeatsPerLine(), otherProgram.getLinesPerBar());
    }

    public boolean hasPowerChanged() {
        return this.hasPower() != this.poweredLastTick;
    }

    protected static RedstoneLinkNetworkHandler getHandler() {
        return Create.REDSTONE_LINK_NETWORK_HANDLER;
    }

    protected static boolean isValidWorld(LevelAccessor level) {
        return level != null && !level.isClientSide();
    }

    public Consumer<RegistryFriendlyByteBuf> writeToMenu() {
        return buffer -> {
            ENCODER.encode(buffer, (Object)this);
            buffer.writeBoolean(this.hasPower());
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RedstoneProgram)) {
            return false;
        }
        RedstoneProgram program = (RedstoneProgram)obj;
        return this.mode == program.mode && this.length == program.length && this.playtime == program.playtime && this.ticksToNextBeat == program.ticksToNextBeat && this.paused == program.paused && this.pausedLastTick == program.pausedLastTick && this.poweredLastTick == program.poweredLastTick && this.ticksPerBeat == program.ticksPerBeat && this.beatsPerLine == program.beatsPerLine && this.linesPerBar == program.linesPerBar && this.channels.equals(program.channels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.length, this.playtime, this.ticksToNextBeat, this.paused, this.pausedLastTick, this.poweredLastTick, this.channels, this.ticksPerBeat, this.beatsPerLine, this.linesPerBar});
    }

    @FunctionalInterface
    public static interface Factory<PROGRAM extends RedstoneProgram> {
        public PROGRAM create(PlayMode var1, int var2, int var3, int var4, boolean var5, boolean var6, boolean var7, List<ChannelData> var8, int var9, int var10, int var11);
    }

    public static enum PlayMode implements StringRepresentable
    {
        MANUAL(true, false, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_MANUAL),
        SWITCH_ON_PULSE(false, false, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_SWITCH_ON_PULSE),
        RESTART_ON_PULSE(true, false, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_RESTART_ON_PULSE),
        RESUME_WITH_POWER(false, true, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_RESUME_WITH_POWER),
        RESTART_WITH_POWER(true, true, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_RESTART_WITH_POWER),
        LOOP_WITH_POWER(false, true, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_LOOP_WITH_POWER),
        LOOP(false, false, PetrolparkIcon.REDSTONE_PROGRAMMER_MODE_LOOP);

        public static final Codec<PlayMode> CODEC;
        public final boolean pausesWhenFinished;
        public final boolean powerRequired;
        public final Component description;
        public final PetrolparkIcon icon;

        private PlayMode(boolean pausesWhenFinished, boolean powerRequired, PetrolparkIcon icon) {
            this.pausesWhenFinished = pausesWhenFinished;
            this.powerRequired = powerRequired;
            this.description = Component.translatable((String)(Util.makeDescriptionId((String)"block", (ResourceLocation)CreateBlocks.REDSTONE_PROGRAMMER.getId()) + ".mode." + Lang.asId(this.name())));
            this.icon = icon;
        }

        public String getSerializedName() {
            return Lang.asId(this.name());
        }

        static {
            CODEC = StringRepresentable.fromEnum(PlayMode::values);
        }
    }

    public record ChannelData(Couple<RedstoneLinkNetworkHandler.Frequency> networkKey, int[] sequence) {
        public static final Codec<ChannelData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Couple.codec((Codec)ItemStack.OPTIONAL_CODEC.xmap(RedstoneLinkNetworkHandler.Frequency::of, RedstoneLinkNetworkHandler.Frequency::getStack)).fieldOf("frequency").forGetter(ChannelData::networkKey), (App)Codec.INT_STREAM.xmap(IntStream::toArray, Arrays::stream).fieldOf("sequence").forGetter(ChannelData::sequence)).apply((Applicative)instance, ChannelData::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ChannelData> STREAM_CODEC = StreamCodec.composite((StreamCodec)Couple.streamCodec((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC.map(RedstoneLinkNetworkHandler.Frequency::of, RedstoneLinkNetworkHandler.Frequency::getStack)), ChannelData::networkKey, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVarIntArray, FriendlyByteBuf::readVarIntArray), ChannelData::sequence, ChannelData::new);
    }

    public class Channel
    implements IRedstoneLinkable {
        public final Couple<RedstoneLinkNetworkHandler.Frequency> networkKey;
        protected int[] sequence;

        protected Channel(ChannelData data) {
            this(data.networkKey(), data.sequence());
        }

        protected Channel(Couple<RedstoneLinkNetworkHandler.Frequency> networkKey, int[] sequence) {
            this.networkKey = networkKey;
            this.sequence = sequence;
        }

        public ChannelData asData() {
            return new ChannelData(this.networkKey, this.sequence);
        }

        protected void updateNetwork() {
            if (!RedstoneProgram.isValidWorld(RedstoneProgram.this.getWorld())) {
                return;
            }
            if (RedstoneProgram.this.playtime == 0 || this.sequence[RedstoneProgram.this.playtime] != this.sequence[RedstoneProgram.this.playtime - 1]) {
                RedstoneProgram.getHandler().updateNetworkOf(RedstoneProgram.this.getWorld(), (IRedstoneLinkable)this);
            }
        }

        public int getStrength(int position) {
            if (position >= this.sequence.length || position < 0) {
                return 0;
            }
            return this.sequence[position];
        }

        public void setStrength(int position, int strength) {
            if (position < RedstoneProgram.this.length) {
                if (strength >= 16 || strength < 0) {
                    strength = 0;
                }
                this.sequence[position] = strength;
            }
        }

        public void clear() {
            this.sequence = new int[RedstoneProgram.this.length];
        }

        public int getTransmittedStrength() {
            if (RedstoneProgram.this.playtime >= RedstoneProgram.this.length) {
                return 0;
            }
            return this.sequence[RedstoneProgram.this.playtime];
        }

        public void setReceivedStrength(int power) {
        }

        public boolean isListening() {
            return false;
        }

        public boolean isAlive() {
            return RedstoneProgram.this.shouldTransmit();
        }

        public Couple<RedstoneLinkNetworkHandler.Frequency> getNetworkKey() {
            return this.networkKey;
        }

        public BlockPos getLocation() {
            return RedstoneProgram.this.getBlockPos();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Channel)) {
                return false;
            }
            Channel channel = (Channel)obj;
            return this.networkKey.equals(channel.networkKey) && this.sequence.equals(channel.sequence);
        }

        public int hashCode() {
            return Objects.hash(this.networkKey, this.sequence, RedstoneProgram.this.getHashSalt());
        }
    }
}

