/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.mojang.serialization.MapCodec;
import com.petrolpark.compat.create.CreateBlockEntityTypes;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlockEntity;
import com.petrolpark.compat.create.core.CreateShapes;
import com.petrolpark.core.block.IPickUpPutDownBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneProgrammerBlock
extends HorizontalDirectionalBlock
implements IBE<RedstoneProgrammerBlockEntity>,
IWrenchable,
ProperWaterloggedBlock,
IPickUpPutDownBlock {
    public static final MapCodec<RedstoneProgrammerBlock> CODEC = HorizontalDirectionalBlock.simpleCodec(RedstoneProgrammerBlock::new);
    public static final VoxelShape SHAPE = CreateShapes.shape(1.0, 0.0, 1.0, 15.0, 3.0, 15.0).add(2.0, 3.0, 2.0, 14.0, 10.0, 14.0).build();
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public RedstoneProgrammerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> player.openMenu((MenuProvider)be.programmer, be.programmer.program.writeToMenu()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return SHAPE;
    }

    public void neighborChanged(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (level.isClientSide()) {
            return;
        }
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 0);
        }
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void tick(@Nonnull BlockState state, @Nonnull ServerLevel worldIn, @Nonnull BlockPos pos, @Nonnull RandomSource r) {
        this.updatePower(state, (Level)worldIn, pos);
    }

    public void onPlace(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState oldState, boolean isMoving) {
        if (state.getBlock() == oldState.getBlock() || isMoving) {
            return;
        }
        this.updatePower(state, worldIn, pos);
    }

    public void updatePower(BlockState state, Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() != level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BlockState updateShape(@Nonnull BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighborState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos neighborPos) {
        this.updateWater(level, state, currentPos);
        return state;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWERED}).add(new Property[]{FACING}).add(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return this.withWater((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection()), context);
    }

    public FluidState getFluidState(@Nonnull BlockState state) {
        return this.fluidState(state);
    }

    protected boolean isPathfindable(@Nonnull BlockState state, @Nonnull PathComputationType pathComputationType) {
        return false;
    }

    public Class<RedstoneProgrammerBlockEntity> getBlockEntityClass() {
        return RedstoneProgrammerBlockEntity.class;
    }

    public BlockEntityType<RedstoneProgrammerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CreateBlockEntityTypes.REDSTONE_PROGRAMMER.get();
    }
}

