/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.petrolpark.compat.create.PetrolparkPartialModels;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBehaviour;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlock;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneProgrammerBlockEntityRenderer
extends SafeBlockEntityRenderer<RedstoneProgrammerBlockEntity> {
    public RedstoneProgrammerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(RedstoneProgrammerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource bufferSource, int light, int overlay) {
        Direction direction = (Direction)be.getBlockState().getValue((Property)RedstoneProgrammerBlock.FACING);
        RedstoneProgrammerBehaviour.BehaviourRedstoneProgram program = be.programmer.program;
        VertexConsumer vc = bufferSource.getBuffer(RenderType.cutout());
        SuperByteBuffer cylinder = (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)PetrolparkPartialModels.REDSTONE_PROGRAMMER_CYLINDER, (BlockState)be.getBlockState()).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).uncenter();
        SuperByteBuffer needle = (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)PetrolparkPartialModels.REDSTONE_PROGRAMMER_NEEDLE, (BlockState)be.getBlockState()).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).uncenter();
        float rotation = program.paused ? 0.0f : AnimationTickHolder.getRenderTime();
        ((SuperByteBuffer)((SuperByteBuffer)cylinder.translate(0.0, 0.375, 0.625)).rotateXDegrees(rotation)).translateBack(0.0, 0.375, 0.625);
        ((SuperByteBuffer)((SuperByteBuffer)needle.translate(0.0, 0.53125, 0.34375)).rotateXDegrees(-2.0f + 8.0f * -Mth.sin((float)(4.0f * AngleHelper.rad((double)rotation))))).translateBack(0.0, 0.53125, 0.34375);
        cylinder.light(light).renderInto(ms, vc);
        needle.light(light).renderInto(ms, vc);
        ImmutableList<RedstoneProgram.Channel> channels = program.getChannels();
        for (int i = 0; i < 6; ++i) {
            if (i >= channels.size()) continue;
            boolean powered = !program.paused && ((RedstoneProgram.Channel)program.getChannels().get(i)).getTransmittedStrength() != 0;
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)(powered ? PetrolparkPartialModels.REDSTONE_PROGRAMMER_TRANSMITTER_POWERED : PetrolparkPartialModels.REDSTONE_PROGRAMMER_TRANSMITTER), (BlockState)be.getBlockState()).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)direction))).translate(i % 2 == 0 ? 0.0f : 0.9375f, 0.0625f, (3.0f + 4.5f * (float)(i / 2)) / 16.0f)).uncenter()).light(light).renderInto(ms, vc);
        }
    }
}

