/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.mojang.serialization.Codec;
import com.petrolpark.compat.ISharedFeature;
import com.petrolpark.compat.SharedFeatureFlag;
import com.petrolpark.compat.create.CreateDataComponentTypes;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerBlock;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerItemHandler;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerItemRenderer;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgrammerMenu;
import com.petrolpark.core.block.IPickUpPutDownBlock;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class RedstoneProgrammerBlockItem
extends BlockItem
implements ISharedFeature {
    public RedstoneProgrammerBlockItem(RedstoneProgrammerBlock block, Item.Properties properties) {
        super((Block)block, properties);
        properties.stacksTo(1);
    }

    public InteractionResult onItemUseFirst(@Nonnull ItemStack stack, @Nonnull UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isShiftKeyDown()) {
            return super.onItemUseFirst(stack, context);
        }
        RedstoneProgrammerBlockItem.openScreen(stack, context.getLevel(), player);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult place(@Nonnull BlockPlaceContext context) {
        return IPickUpPutDownBlock.removeItemFromInventory(context, super.place(context));
    }

    public InteractionResultHolder<ItemStack> use(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        RedstoneProgrammerBlockItem.openScreen(stack, level, player);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(usedHand));
    }

    public static final void openScreen(ItemStack stack, Level level, Player player) {
        RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, (LivingEntity)player).ifPresent(program -> {
            if (!level.isClientSide()) {
                player.openMenu((MenuProvider)new ItemStackRedstoneProgramMenuOpener((RedstoneProgram)program), program.writeToMenu());
            }
        });
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity player = (LivingEntity)entity;
            RedstoneProgrammerBlockItem.getProgram(stack, (LevelAccessor)level, player).ifPresent(program -> {
                if (!level.isClientSide()) {
                    program.load();
                }
                program.tick();
                stack.set(CreateDataComponentTypes.REDSTONE_PROGRAM, program);
            });
        }
    }

    public boolean shouldCauseReequipAnimation(@Nonnull ItemStack from, @Nonnull ItemStack to, boolean slotChanged) {
        return !(from.getItem() instanceof RedstoneProgrammerBlockItem) || !(to.getItem() instanceof RedstoneProgrammerBlockItem);
    }

    public boolean shouldCauseBlockBreakReset(@Nonnull ItemStack from, @Nonnull ItemStack to) {
        return !(from.getItem() instanceof RedstoneProgrammerBlockItem) || !(to.getItem() instanceof RedstoneProgrammerBlockItem);
    }

    public static Optional<ItemStackRedstoneProgram> getProgram(ItemStack stack, LevelAccessor level, LivingEntity player) {
        UUID uuid;
        if (!(stack.getItem() instanceof RedstoneProgrammerBlockItem) || player == null) {
            return Optional.empty();
        }
        if (stack.has(CreateDataComponentTypes.REDSTONE_PROGRAM_UUID)) {
            uuid = (UUID)stack.get(CreateDataComponentTypes.REDSTONE_PROGRAM_UUID);
        } else {
            uuid = UUID.randomUUID();
            stack.set(CreateDataComponentTypes.REDSTONE_PROGRAM_UUID, (Object)uuid);
        }
        ItemStackRedstoneProgram program = level.isClientSide() ? (stack.has(CreateDataComponentTypes.REDSTONE_PROGRAM) ? (ItemStackRedstoneProgram)stack.get(CreateDataComponentTypes.REDSTONE_PROGRAM) : new ItemStackRedstoneProgram()) : ((Map)RedstoneProgrammerItemHandler.PROGRAMS.get(level)).computeIfAbsent(uuid, u -> {
            if (stack.has(CreateDataComponentTypes.REDSTONE_PROGRAM)) {
                return (ItemStackRedstoneProgram)stack.get(CreateDataComponentTypes.REDSTONE_PROGRAM);
            }
            return new ItemStackRedstoneProgram();
        });
        if (program != null) {
            program.withPlayer(player);
        }
        return Optional.ofNullable(program);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new RedstoneProgrammerItemRenderer()));
    }

    @Override
    public SharedFeatureFlag getSharedFeatureFlag() {
        return SharedFeatureFlag.REDSTONE_PROGRAMMER;
    }

    public static class ItemStackRedstoneProgram
    extends RedstoneProgram {
        public static final Codec<ItemStackRedstoneProgram> CODEC = RedstoneProgram.codec(ItemStackRedstoneProgram::new);
        public int ttl;
        protected UUID uuid;
        protected LivingEntity player = null;

        public ItemStackRedstoneProgram() {
        }

        public ItemStackRedstoneProgram(RedstoneProgram.PlayMode mode, int length, int playtime, int ticksToNextBeat, boolean paused, boolean pausedLastTick, boolean poweredLastTick, List<RedstoneProgram.ChannelData> channels, int ticksPerBeat, int beatsPerLine, int linesPerBar) {
            super(mode, length, playtime, ticksToNextBeat, paused, pausedLastTick, poweredLastTick, channels, ticksPerBeat, beatsPerLine, linesPerBar);
        }

        public ItemStackRedstoneProgram withPlayer(LivingEntity player) {
            this.player = player;
            return this;
        }

        @Override
        public void load() {
            if (this.player != null && this.player.getOnPos() != null) {
                super.load();
            }
        }

        @Override
        public void tick() {
            this.ttl = 30;
            super.tick();
        }

        @Override
        public boolean hasPower() {
            return false;
        }

        @Override
        public BlockPos getBlockPos() {
            return this.player.getOnPos();
        }

        @Override
        public boolean shouldTransmit() {
            return this.ttl > 0;
        }

        @Override
        public LevelAccessor getWorld() {
            return this.player.level();
        }

        @Override
        public ItemStackRedstoneProgram copyFrom(RedstoneProgram otherProgram) {
            super.copyFrom(otherProgram);
            return this;
        }
    }

    public record ItemStackRedstoneProgramMenuOpener(RedstoneProgram program) implements MenuProvider
    {
        public AbstractContainerMenu createMenu(int id, @Nonnull Inventory inv, @Nonnull Player player) {
            return RedstoneProgrammerMenu.create(id, inv, this.program);
        }

        public Component getDisplayName() {
            return Component.empty();
        }
    }
}

