/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.common.redstone.programmer;

import com.petrolpark.compat.create.CreateMenuTypes;
import com.petrolpark.compat.create.common.redstone.programmer.ChangeRedstoneProgrammerPowerPacket;
import com.petrolpark.compat.create.common.redstone.programmer.RedstoneProgram;
import com.petrolpark.compat.create.common.redstone.programmer.SetRedstoneProgramPacket;
import com.petrolpark.compat.jei.ghost.IConditionalGhostSlot;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.inventory.DummyContainer;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

@EventBusSubscriber
public class RedstoneProgrammerMenu
extends GhostItemMenu<RedstoneProgram> {
    public static final int SCREEN_ITEM_AREA_X = 3;
    public static final int SCREEN_ITEM_AREA_Y = 31;
    public static final int SCREEN_ITEM_AREA_WIDTH = 73;
    public static final int SCREEN_ITEM_AREA_HEIGHT = 154;
    public static final int SCREEN_DISTANCE_BETWEEN_CHANNELS = 20;
    private int offset = 0;
    private static final WeakHashMap<ServerPlayer, Boolean> programmersPowered = new WeakHashMap();

    public RedstoneProgrammerMenu(MenuType<?> type, int id, Inventory inv, RegistryFriendlyByteBuf buf) {
        super(type, id, inv, buf);
    }

    protected RedstoneProgrammerMenu(MenuType<?> type, int id, Inventory inv, RedstoneProgram contentHolder) {
        super(type, id, inv, (Object)contentHolder);
    }

    public static RedstoneProgrammerMenu create(int id, Inventory inv, RedstoneProgram program) {
        return new RedstoneProgrammerMenu((MenuType)CreateMenuTypes.REDSTONE_PROGRAMMER.get(), id, inv, program);
    }

    protected RedstoneProgram createOnClient(RegistryFriendlyByteBuf extraData) {
        DummyRedstoneProgram program = (DummyRedstoneProgram)DummyRedstoneProgram.STREAM_CODEC.decode((Object)extraData);
        program.powered = extraData.readBoolean();
        return program;
    }

    protected ItemStackHandler createGhostInventory() {
        return new ItemStackHandler(RedstoneProgrammerMenu.maxSlots((RedstoneProgram)this.contentHolder));
    }

    protected boolean allowRepeats() {
        return true;
    }

    public boolean canDragTo(Slot slotIn) {
        return true;
    }

    protected void addSlots() {
        this.refreshSlots(0);
    }

    public void refreshSlots() {
        this.refreshSlots(this.offset);
    }

    public void refreshSlots(int offset) {
        this.ghostInventory = this.createGhostInventory();
        this.offset = offset;
        this.slots.clear();
        this.lastSlots.clear();
        this.remoteSlots.clear();
        DummyContainer.addFakePlayerSlots(arg_0 -> ((RedstoneProgrammerMenu)this).addSlot(arg_0));
        int i = 0;
        int position = 15 - this.offset;
        for (int channel = 0; channel < Math.min(((RedstoneProgram)this.contentHolder).getChannels().size() + 1, (Integer)PetrolparkConfigs.server().redstoneProgrammerMaxChannels.get()); ++channel) {
            Slot slot1 = this.addSlot((Slot)new FrequencySlotItemHandler(i++, 35, position += 20, channel, true));
            Slot slot2 = this.addSlot((Slot)new FrequencySlotItemHandler(i++, 53, position, channel, false));
            if (channel >= ((RedstoneProgram)this.contentHolder).getChannels().size()) continue;
            slot1.set(((RedstoneLinkNetworkHandler.Frequency)((RedstoneProgram.Channel)((RedstoneProgram)this.contentHolder).getChannels().get((int)channel)).networkKey.getFirst()).getStack());
            slot2.set(((RedstoneLinkNetworkHandler.Frequency)((RedstoneProgram.Channel)((RedstoneProgram)this.contentHolder).getChannels().get((int)channel)).networkKey.getSecond()).getStack());
        }
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public void sync() {
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new SetRedstoneProgramPacket((RedstoneProgram)this.contentHolder));
    }

    protected void saveData(RedstoneProgram contentHolder) {
    }

    public static int maxSlots(RedstoneProgram program) {
        return 2 * Math.min(program.getChannels().size() + 1, (Integer)PetrolparkConfigs.server().redstoneProgrammerMaxChannels.get());
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AbstractContainerMenu abstractContainerMenu = player2.containerMenu;
            if (abstractContainerMenu instanceof RedstoneProgrammerMenu) {
                RedstoneProgrammerMenu menu = (RedstoneProgrammerMenu)abstractContainerMenu;
                boolean currentPower = ((RedstoneProgram)menu.contentHolder).hasPower();
                Boolean oldPower = programmersPowered.get(player2);
                if (oldPower == null || currentPower != oldPower) {
                    CatnipServices.NETWORK.sendToClient(player2, (CustomPacketPayload)new ChangeRedstoneProgrammerPowerPacket(((RedstoneProgram)menu.contentHolder).hasPower()));
                    programmersPowered.put(player2, currentPower);
                }
            } else {
                programmersPowered.remove(player2);
            }
        }
    }

    public static class DummyRedstoneProgram
    extends RedstoneProgram {
        public static final StreamCodec<RegistryFriendlyByteBuf, DummyRedstoneProgram> STREAM_CODEC = RedstoneProgram.streamCodec(DummyRedstoneProgram::new);
        public boolean powered;

        public DummyRedstoneProgram() {
        }

        public DummyRedstoneProgram(RedstoneProgram.PlayMode mode, int length, int playtime, int ticksToNextBeat, boolean paused, boolean pausedLastTick, boolean poweredLastTick, List<RedstoneProgram.ChannelData> channels, int ticksPerBeat, int beatsPerLine, int linesPerBar) {
            super(mode, length, playtime, ticksToNextBeat, paused, pausedLastTick, poweredLastTick, channels, ticksPerBeat, beatsPerLine, linesPerBar);
        }

        @Override
        public void load() {
        }

        @Override
        public boolean hasPower() {
            return this.powered;
        }

        @Override
        public BlockPos getBlockPos() {
            return null;
        }

        @Override
        public boolean shouldTransmit() {
            return false;
        }

        @Override
        public LevelAccessor getWorld() {
            return null;
        }
    }

    public class FrequencySlotItemHandler
    extends SlotItemHandler
    implements IConditionalGhostSlot {
        public final int channelIndex;
        public final boolean first;

        public FrequencySlotItemHandler(int index, int xPosition, int yPosition, int channelIndex, boolean first) {
            super((IItemHandler)RedstoneProgrammerMenu.this.ghostInventory, index, xPosition, yPosition);
            this.channelIndex = channelIndex;
            this.first = first;
        }

        public void set(@Nonnull ItemStack stack) {
            boolean sync = true;
            if (this.channelIndex >= ((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).getChannels().size()) {
                if (stack.isEmpty()) {
                    sync = false;
                } else {
                    Couple networkKey = Couple.create((Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.EMPTY), (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)ItemStack.EMPTY));
                    networkKey.set(this.first, (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack));
                    ((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).addBlankChannel((Couple<RedstoneLinkNetworkHandler.Frequency>)networkKey);
                }
            } else if (!((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).getChannels().isEmpty()) {
                RedstoneProgram.Channel channel = (RedstoneProgram.Channel)((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).getChannels().get(this.channelIndex);
                if (((RedstoneLinkNetworkHandler.Frequency)channel.networkKey.get(this.first)).getStack().equals(stack)) {
                    sync = false;
                } else {
                    channel.networkKey.set(this.first, (Object)RedstoneLinkNetworkHandler.Frequency.of((ItemStack)stack));
                    if (channel.networkKey.both(f -> f.getStack().isEmpty())) {
                        ((RedstoneProgram)RedstoneProgrammerMenu.this.contentHolder).remove(channel);
                    }
                }
            } else {
                sync = false;
            }
            if (sync) {
                RedstoneProgrammerMenu.this.sync();
                RedstoneProgrammerMenu.this.refreshSlots();
            }
            super.set(stack);
        }

        @Override
        public boolean canSetGhostItem() {
            int position = 20 * this.channelIndex - RedstoneProgrammerMenu.this.offset;
            return position > -1 && position < 134;
        }
    }
}

