/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.item.directional;

import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.core.item.directional.IDirectionalOnBelt;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Rotation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@RequiresCreate
public class DirectionalTransportedItemStack
extends TransportedItemStack {
    @Nullable
    protected Rotation rotation;

    public DirectionalTransportedItemStack(ItemStack stack) {
        super(stack);
        Item item = stack.getItem();
        if (item instanceof IDirectionalOnBelt) {
            IDirectionalOnBelt item2 = (IDirectionalOnBelt)item;
            v0 = item2.rotationForPlacement(stack);
        } else {
            v0 = this.rotation = null;
        }
        if (this.rotation == null) {
            this.rotation = Rotation.NONE;
        }
        this.refreshAngle();
    }

    public float getTargetSideOffset() {
        return 0.0f;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public void rotate(Rotation appliedRotation) {
        if (this.rotation != null) {
            this.rotation = appliedRotation.getRotated(this.rotation);
        }
        this.refreshAngle();
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.refreshAngle();
    }

    public void refreshAngle() {
        if (this.rotation != null) {
            this.angle = this.getTargetAngle();
        }
    }

    public final int getTargetAngle() {
        Rotation rotation = this.rotation;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NONE", "CLOCKWISE_90", "CLOCKWISE_180", "COUNTERCLOCKWISE_90"}, (Rotation)rotation, n)) {
            case 0: {
                return 180;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public TransportedItemStack getSimilar() {
        return DirectionalTransportedItemStack.copy(this);
    }

    public TransportedItemStack copy() {
        return DirectionalTransportedItemStack.copy(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean overrideRender(ItemRenderer itemRenderer, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        return false;
    }

    public static DirectionalTransportedItemStack copy(TransportedItemStack transportedItemStack) {
        return DirectionalTransportedItemStack.copy(transportedItemStack, DirectionalTransportedItemStack::new);
    }

    public static <DTIS extends DirectionalTransportedItemStack> DTIS copy(TransportedItemStack transportedItemStack, Function<ItemStack, DTIS> dtisFactory) {
        DirectionalTransportedItemStack copy = (DirectionalTransportedItemStack)((Object)dtisFactory.apply(transportedItemStack.stack.copy()));
        copy.beltPosition = transportedItemStack.beltPosition;
        copy.insertedAt = transportedItemStack.insertedAt;
        copy.insertedFrom = transportedItemStack.insertedFrom;
        copy.prevBeltPosition = transportedItemStack.prevBeltPosition;
        copy.prevSideOffset = transportedItemStack.prevSideOffset;
        copy.processedBy = transportedItemStack.processedBy;
        copy.processingTime = transportedItemStack.processingTime;
        if (transportedItemStack instanceof DirectionalTransportedItemStack) {
            DirectionalTransportedItemStack directionalStack = (DirectionalTransportedItemStack)transportedItemStack;
            if (directionalStack.rotation != null) {
                copy.rotation = directionalStack.rotation;
            }
            copy.refreshAngle();
        }
        return (DTIS)((Object)copy);
    }

    public static DirectionalTransportedItemStack copyFully(TransportedItemStack transportedItemStack) {
        return DirectionalTransportedItemStack.copyFully(transportedItemStack, DirectionalTransportedItemStack::new);
    }

    public static <DTIS extends DirectionalTransportedItemStack> DTIS copyFully(TransportedItemStack transportedItemStack, Function<ItemStack, DTIS> dtisFactory) {
        DTIS copy = DirectionalTransportedItemStack.copy(transportedItemStack, dtisFactory);
        ((DirectionalTransportedItemStack)((Object)copy)).locked = transportedItemStack.locked;
        ((DirectionalTransportedItemStack)((Object)copy)).lockedExternally = transportedItemStack.lockedExternally;
        return copy;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag nbt = super.serializeNBT(registries);
        if (this.rotation != null) {
            nbt.putInt("Rotation", this.rotation.ordinal());
        }
        return nbt;
    }
}

