/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.create.core.tube;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.create.CreatePackets;
import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.core.actionrecord.packet.recordable.AlwaysEnterRecordablePacketPayload;
import com.petrolpark.util.ItemHelper;
import net.createmod.catnip.net.base.BasePacketPayload;
import net.createmod.catnip.net.base.ServerboundPacketPayload;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@RequiresCreate
public class BuildTubePacket
implements ServerboundPacketPayload,
AlwaysEnterRecordablePacketPayload {
    public static final StreamCodec<RegistryFriendlyByteBuf, BuildTubePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), BuildTubePacket::getBlock, TubeSpline.Provider.STREAM_CODEC, BuildTubePacket::getSplineProvider, BuildTubePacket::new);
    public final Block block;
    public final ITubeBlock tubeBlock;
    public final TubeSpline spline;

    public BuildTubePacket(Block block, TubeSpline.Provider splineProvider) {
        ITubeBlock tubeBlock;
        this.block = block;
        if (!(block instanceof ITubeBlock)) {
            throw new IllegalArgumentException(block.toString() + " is not a Tube Block");
        }
        this.tubeBlock = tubeBlock = (ITubeBlock)block;
        this.spline = splineProvider.provide(tubeBlock.getTubeMaxAngle(), tubeBlock.getTubeSegmentLength(), tubeBlock.getTubeSegmentRadius());
    }

    public BuildTubePacket(ITubeBlock tubeBlock, TubeSpline spline) {
        Block block;
        this.tubeBlock = tubeBlock;
        if (!(tubeBlock instanceof Block)) {
            throw new IllegalArgumentException("That is not a block");
        }
        this.block = block = (Block)tubeBlock;
        this.spline = spline;
    }

    public Block getBlock() {
        return this.block;
    }

    public TubeSpline.Provider getSplineProvider() {
        return this.spline.getProvider();
    }

    public void handle(ServerPlayer player) {
        if (this.tubeBlock == null) {
            return;
        }
        this.spline.validate(player.level(), (Player)player, this.block.asItem(), this.tubeBlock);
        if (this.spline.getResult().success) {
            if (!player.getAbilities().instabuild) {
                ItemHelper.removeItems((IItemHandler)new InvWrapper((Container)player.getInventory()), s -> s.is(this.block.asItem()), this.tubeBlock.getItemsForTubeLength(this.spline.getLength()));
            }
            this.tubeBlock.connectTube(player.level(), this.spline);
        }
    }

    public BasePacketPayload.PacketTypeProvider getTypeProvider() {
        return CreatePackets.BUILD_TUBE;
    }

    @Override
    public Component getDescription(ServerLevel level) {
        return this.translate(new Object[]{this.spline.start.getPos().toShortString(), this.spline.end.getPos().toShortString()});
    }
}

