/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.compat.jei.ghost;

import com.petrolpark.RequiresCreate;
import com.petrolpark.compat.jei.ghost.IConditionalGhostSlot;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.menu.GhostItemMenu;
import com.simibubi.create.foundation.gui.menu.GhostItemSubmitPacket;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@RequiresCreate
public class PetrolparkGhostIngredientHandler<MENU extends GhostItemMenu<?>, SCREEN extends AbstractSimiContainerScreen<? extends MENU>>
implements IGhostIngredientHandler<SCREEN> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(@Nonnull SCREEN gui, @Nonnull ITypedIngredient<I> ingredient, boolean doStart) {
        LinkedList<IGhostIngredientHandler.Target<I>> targets = new LinkedList<IGhostIngredientHandler.Target<I>>();
        if (ingredient.getType() == VanillaTypes.ITEM_STACK) {
            for (int i = 36; i < ((GhostItemMenu)gui.getMenu()).slots.size(); ++i) {
                IConditionalGhostSlot ghostSlot;
                Slot slot = (Slot)((GhostItemMenu)gui.getMenu()).slots.get(i);
                if (!slot.isActive() || slot instanceof IConditionalGhostSlot && !(ghostSlot = (IConditionalGhostSlot)slot).canSetGhostItem()) continue;
                targets.add(new PetrolparkGhostTarget(gui, i - 36));
            }
        }
        return targets;
    }

    public void onComplete() {
    }

    public boolean shouldHighlightTargets() {
        return true;
    }

    public static class PetrolparkGhostTarget<I, MENU extends GhostItemMenu<?>, SCREEN extends AbstractSimiContainerScreen<? extends MENU>>
    implements IGhostIngredientHandler.Target<I> {
        private final Rect2i area;
        private final SCREEN screen;
        private final int slotIndex;

        public PetrolparkGhostTarget(SCREEN screen, int slotIndex) {
            this.screen = screen;
            this.slotIndex = slotIndex;
            Slot slot = (Slot)((GhostItemMenu)screen.getMenu()).slots.get(slotIndex + 36);
            this.area = new Rect2i(screen.getGuiLeft() + slot.x, screen.getGuiTop() + slot.y, 16, 16);
        }

        public Rect2i getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            ItemStack stack = ((ItemStack)ingredient).copy();
            stack.setCount(1);
            ((GhostItemMenu)this.screen.getMenu()).ghostInventory.setStackInSlot(this.slotIndex, stack);
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new GhostItemSubmitPacket(stack, this.slotIndex));
        }
    }
}

