/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.actionrecord.packet;

import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.petrolpark.PetrolparkRegistries;
import com.petrolpark.core.actionrecord.IRecordedAction;
import com.petrolpark.core.actionrecord.RecordedActionExecutionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.connection.ConnectionType;

public record PacketRecordedAction(Packet<? super ServerGamePacketListener> packet) implements IRecordedAction<PacketRecordedAction>
{
    protected static final Supplier<ProtocolInfo<ServerGamePacketListener>> PROTOCOL_INFO = Suppliers.memoize(() -> GameProtocols.SERVERBOUND_TEMPLATE.bind(RegistryFriendlyByteBuf.decorator((RegistryAccess)PetrolparkRegistries.registryAccess(), (ConnectionType)ConnectionType.NEOFORGE)));
    public static final Codec<PacketRecordedAction> CODEC = Codec.lazyInitialized(() -> Codec.BYTE_BUFFER.flatXmap(byteBuffer -> {
        Packet packet;
        try {
            packet = (Packet)PROTOCOL_INFO.get().codec().decode((Object)Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
        return DataResult.success((Object)packet);
    }, packet -> {
        ByteBuffer nioBuffer;
        try {
            ByteBuf buf = Unpooled.buffer((int)32768);
            PROTOCOL_INFO.get().codec().encode((Object)buf, packet);
            nioBuffer = buf.nioBuffer();
        }
        catch (Throwable e) {
            return DataResult.error(e::getMessage);
        }
        return DataResult.success((Object)nioBuffer);
    }).xmap(PacketRecordedAction::new, PacketRecordedAction::packet));

    @Override
    public void play(ServerPlayer player) throws RecordedActionExecutionException {
        this.packet.handle((PacketListener)player.connection);
    }

    @Override
    public Codec<PacketRecordedAction> codec() {
        return CODEC;
    }
}

