/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber
public interface IPickUpPutDownBlock {
    public static InteractionResult removeItemFromInventory(BlockPlaceContext context, InteractionResult result) {
        Player player = context.getPlayer();
        if (result == InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) && player != null && player.hasInfiniteMaterials()) {
            context.getItemInHand().shrink(1);
        }
        return result;
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (state.getBlock() instanceof IPickUpPutDownBlock) {
            Level level;
            if (!(event.getEntity() instanceof FakePlayer) && (level = event.getLevel()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                List drops = Block.getDrops((BlockState)state, (ServerLevel)level2, (BlockPos)event.getPos(), (BlockEntity)level2.getBlockEntity(event.getPos()), (Entity)event.getEntity(), (ItemStack)event.getItemStack());
                BlockState removedBlockState = state.getBlock().playerWillDestroy((Level)level2, event.getPos(), state, event.getEntity());
                FluidState fluidState = level2.getFluidState(event.getPos());
                if (state.getBlock().onDestroyedByPlayer(state, (Level)level2, event.getPos(), event.getEntity(), false, fluidState)) {
                    state.getBlock().destroy((LevelAccessor)level2, event.getPos(), removedBlockState);
                    event.getEntity().awardStat(Stats.BLOCK_MINED.get((Object)state.getBlock()));
                    drops.forEach(arg_0 -> ((Inventory)event.getEntity().getInventory()).placeItemBackInInventory(arg_0));
                }
            }
            event.setUseBlock(TriState.FALSE);
            event.setCanceled(true);
        }
    }
}

