/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.petrolpark.core.codec.ContextualDecoder;
import com.petrolpark.core.codec.ContextualMapDecoder;
import java.util.Objects;
import java.util.stream.Stream;

public final class ContextualFieldDecoder<CONTEXT, A>
extends ContextualMapDecoder.Implementation<CONTEXT, A> {
    protected final String name;
    private final ContextualDecoder<CONTEXT, A> elementCodec;

    public ContextualFieldDecoder(String name, ContextualDecoder<CONTEXT, A> elementCodec) {
        this.name = name;
        this.elementCodec = elementCodec;
    }

    @Override
    public <T> DataResult<A> decode(DynamicOps<T> ops, CONTEXT context, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.error(() -> "No key " + this.name + " in " + String.valueOf(input));
        }
        return this.elementCodec.parse(ops, context, value);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualFieldDecoder that = (ContextualFieldDecoder)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementCodec, that.elementCodec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec);
    }

    public String toString() {
        return "FieldDecoder[" + this.name + ": " + String.valueOf(this.elementCodec) + "]";
    }
}

