/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import com.petrolpark.core.codec.ContextualCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.Unit;

public record ContextualListCodec<CONTEXT, E>(ContextualCodec<CONTEXT, E> elementCodec, int minSize, int maxSize) implements ContextualCodec<CONTEXT, List<E>>
{
    private <R> DataResult<R> createTooShortError(int size) {
        return DataResult.error(() -> "List is too short: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    private <R> DataResult<R> createTooLongError(int size) {
        return DataResult.error(() -> "List is too long: " + size + ", expected range [" + this.minSize + "-" + this.maxSize + "]");
    }

    @Override
    public <T> DataResult<T> encode(List<E> input, CONTEXT context, DynamicOps<T> ops, T prefix) {
        if (input.size() < this.minSize) {
            return this.createTooShortError(input.size());
        }
        if (input.size() > this.maxSize) {
            return this.createTooLongError(input.size());
        }
        ListBuilder builder = ops.listBuilder();
        for (E element : input) {
            builder.add(this.elementCodec.encodeStart(ops, context, element));
        }
        return builder.build(prefix);
    }

    @Override
    public <T> DataResult<Pair<List<E>, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops, context);
            stream.accept(decoder::accept);
            return decoder.build();
        });
    }

    @Override
    public String toString() {
        return "ListCodec[" + String.valueOf(this.elementCodec) + "]";
    }

    private class DecoderState<T> {
        private static final DataResult<Unit> INITIAL_RESULT = DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable());
        private final DynamicOps<T> ops;
        private final CONTEXT context;
        private final List<E> elements = new ArrayList();
        private final Stream.Builder<T> failed = Stream.builder();
        private DataResult<Unit> result = INITIAL_RESULT;
        private int totalCount;

        private DecoderState(DynamicOps<T> ops, CONTEXT context) {
            this.ops = ops;
            this.context = context;
        }

        public void accept(T value) {
            ++this.totalCount;
            if (this.elements.size() >= ContextualListCodec.this.maxSize) {
                this.failed.add(value);
                return;
            }
            DataResult elementResult = ContextualListCodec.this.elementCodec.decode(this.ops, this.context, value);
            elementResult.error().ifPresent(error -> this.failed.add(value));
            elementResult.resultOrPartial().ifPresent(pair -> this.elements.add(pair.getFirst()));
            this.result = this.result.apply2stable((result, element) -> result, elementResult);
        }

        public DataResult<Pair<List<E>, T>> build() {
            if (this.elements.size() < ContextualListCodec.this.minSize) {
                return ContextualListCodec.this.createTooShortError(this.elements.size());
            }
            Object errors = this.ops.createList(this.failed.build());
            Pair pair = Pair.of(List.copyOf(this.elements), (Object)errors);
            if (this.totalCount > ContextualListCodec.this.maxSize) {
                this.result = ContextualListCodec.this.createTooLongError(this.totalCount);
            }
            return this.result.map(ignored -> pair).setPartial((Object)pair);
        }
    }
}

