/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.CompressorHolder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualMapDecoder;
import com.petrolpark.core.codec.ContextualMapEncoder;
import com.petrolpark.core.codec.RecordContextualCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class ContextualMapCodec<CONTEXT, A>
extends CompressorHolder
implements ContextualMapEncoder<CONTEXT, A>,
ContextualMapDecoder<CONTEXT, A> {
    public final <O> RecordContextualCodecBuilder<CONTEXT, O, A> forGetter(BiFunction<CONTEXT, O, A> getter) {
        return RecordContextualCodecBuilder.of(getter, this);
    }

    public final <O> RecordContextualCodecBuilder<CONTEXT, O, A> forGetter(Function<O, A> getter) {
        return this.forGetter((CONTEXT c, O o) -> getter.apply(o));
    }

    public static <CONTEXT, A> ContextualMapCodec<CONTEXT, A> of(ContextualMapEncoder<CONTEXT, A> encoder, ContextualMapDecoder<CONTEXT, A> decoder) {
        return ContextualMapCodec.of(encoder, decoder, () -> "MapCodec[" + String.valueOf(encoder) + " " + String.valueOf(decoder) + "]");
    }

    public static <CONTEXT, A> ContextualMapCodec<CONTEXT, A> of(final ContextualMapEncoder<CONTEXT, A> encoder, final ContextualMapDecoder<CONTEXT, A> decoder, final Supplier<String> name) {
        return new ContextualMapCodec<CONTEXT, A>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.concat(encoder.keys(ops), decoder.keys(ops));
            }

            @Override
            public <T> DataResult<A> decode(DynamicOps<T> ops, CONTEXT context, MapLike<T> input) {
                return decoder.decode(ops, context, input);
            }

            @Override
            public <T> RecordBuilder<T> encode(A input, CONTEXT context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return encoder.encode(input, context, ops, prefix);
            }

            public String toString() {
                return (String)name.get();
            }
        };
    }

    public ContextualCodec<CONTEXT, A> codec() {
        return new ContextualMapCodecCodec(this);
    }

    public static <CONTEXT, A> ContextualMapCodec<CONTEXT, A> unit(A defaultValue) {
        return ContextualMapCodec.unit(() -> defaultValue);
    }

    public static <CONTEXT, A> ContextualMapCodec<CONTEXT, A> unit(Supplier<A> defaultValue) {
        return ContextualMapCodec.of(ContextualMapEncoder.empty(), ContextualMapDecoder.unit(defaultValue));
    }

    public record ContextualMapCodecCodec<CONTEXT, A>(ContextualMapCodec<CONTEXT, A> codec) implements ContextualCodec<CONTEXT, A>
    {
        @Override
        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, CONTEXT context, T input) {
            return this.codec.compressedDecode(ops, context, input).map(r -> Pair.of((Object)r, (Object)input));
        }

        @Override
        public <T> DataResult<T> encode(A input, CONTEXT context, DynamicOps<T> ops, T prefix) {
            return this.codec.encode(input, context, ops, this.codec.compressedBuilder(ops)).build(prefix);
        }

        @Override
        public String toString() {
            return this.codec.toString();
        }
    }
}

