/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.CompressorHolder;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.KeyCompressor;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public interface ContextualMapDecoder<CONTEXT, A>
extends Keyable {
    public <T> DataResult<A> decode(DynamicOps<T> var1, CONTEXT var2, MapLike<T> var3);

    default public <T> DataResult<A> compressedDecode(DynamicOps<T> ops, CONTEXT context, T input) {
        if (ops.compressMaps()) {
            Optional inputList = ops.getList(input).result();
            if (!inputList.isPresent()) {
                return DataResult.error(() -> "Input is not a list");
            }
            final KeyCompressor<T> compressor = this.compressor(ops);
            final ArrayList entries = new ArrayList();
            ((Consumer)inputList.get()).accept(entries::add);
            MapLike map2 = new MapLike<T>(){

                @Nullable
                public T get(T key) {
                    return entries.get(compressor.compress(key));
                }

                @Nullable
                public T get(String key) {
                    return entries.get(compressor.compress(key));
                }

                public Stream<Pair<T, T>> entries() {
                    return IntStream.range(0, entries.size()).mapToObj(i -> Pair.of((Object)compressor.decompress(i), entries.get(i))).filter(p -> p.getSecond() != null);
                }
            };
            return this.decode(ops, context, map2);
        }
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(ops, context, (MapLike)map));
    }

    public <T> KeyCompressor<T> compressor(DynamicOps<T> var1);

    default public <B> ContextualMapDecoder<CONTEXT, B> map(final Function<? super A, ? extends B> function) {
        return new Implementation<CONTEXT, B>(){

            @Override
            public <T> DataResult<B> decode(DynamicOps<T> ops, CONTEXT context, MapLike<T> input) {
                return ContextualMapDecoder.this.decode(ops, context, input).map(function);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return ContextualMapDecoder.this.keys(ops);
            }

            public String toString() {
                return ContextualMapDecoder.this.toString() + "[mapped]";
            }
        };
    }

    public static <CONTEXT, A> ContextualMapDecoder<CONTEXT, A> unit(A instance) {
        return ContextualMapDecoder.unit(() -> instance);
    }

    public static <CONTEXT, A> ContextualMapDecoder<CONTEXT, A> unit(final Supplier<A> instance) {
        return new Implementation<CONTEXT, A>(){

            @Override
            public <T> DataResult<A> decode(DynamicOps<T> ops, CONTEXT context, MapLike<T> input) {
                return DataResult.success(instance.get());
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.empty();
            }

            public String toString() {
                return "UnitDecoder[" + String.valueOf(instance.get()) + "]";
            }
        };
    }

    public static abstract class Implementation<CONTEXT, A>
    extends CompressorHolder
    implements ContextualMapDecoder<CONTEXT, A> {
    }
}

