/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.petrolpark.core.codec.ContextualCodec;
import com.petrolpark.core.codec.ContextualMapCodec;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class ContextualOptionalFieldCodec<CONTEXT, A>
extends ContextualMapCodec<CONTEXT, Optional<A>> {
    private final String name;
    private final ContextualCodec<CONTEXT, A> elementCodec;
    private final boolean lenient;

    public ContextualOptionalFieldCodec(String name, ContextualCodec<CONTEXT, A> elementCodec, boolean lenient) {
        this.name = name;
        this.elementCodec = elementCodec;
        this.lenient = lenient;
    }

    @Override
    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, CONTEXT context, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        DataResult parsed = this.elementCodec.parse(ops, context, value);
        if (parsed.isError() && this.lenient) {
            return DataResult.success(Optional.empty());
        }
        return parsed.map(Optional::of).setPartial((Object)parsed.resultOrPartial());
    }

    @Override
    public <T> RecordBuilder<T> encode(Optional<A> input, CONTEXT context, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        if (input.isPresent()) {
            return prefix.add(this.name, this.elementCodec.encodeStart(ops, context, input.get()));
        }
        return prefix;
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualOptionalFieldCodec that = (ContextualOptionalFieldCodec)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementCodec, that.elementCodec) && this.lenient == that.lenient;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementCodec, this.lenient);
    }

    public String toString() {
        return "OptionalFieldCodec[" + this.name + ": " + String.valueOf(this.elementCodec) + "]";
    }
}

