/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.network.codec.StreamCodec;

public interface ContextualStreamCodec<B, CONTEXT, V> {
    public void encode(B var1, CONTEXT var2, V var3);

    public V decode(B var1, CONTEXT var2);

    public static <B, CONTEXT, V> ContextualStreamCodec<B, CONTEXT, V> of(final StreamCodec<B, V> streamCodec) {
        return new ContextualStreamCodec<B, CONTEXT, V>(){

            @Override
            public V decode(B buffer, CONTEXT context) {
                return streamCodec.decode(buffer);
            }

            @Override
            public void encode(B buffer, CONTEXT context, V value) {
                streamCodec.encode(buffer, value);
            }
        };
    }

    public static <B, CONTEXT, V> ContextualStreamCodec<B, CONTEXT, V> unit(final V expectedValue) {
        return new ContextualStreamCodec<B, CONTEXT, V>(){

            @Override
            public V decode(B buffer, CONTEXT context) {
                return expectedValue;
            }

            @Override
            public void encode(B buffer, CONTEXT context, V value) {
                if (!value.equals(expectedValue)) {
                    throw new IllegalStateException("Can't encode '" + String.valueOf(value) + "', expected '" + String.valueOf(expectedValue) + "'");
                }
            }
        };
    }

    public static <B extends ByteBuf, CONTEXT, V> ContextualStreamCodec<B, CONTEXT, Optional<V>> optional(final StreamCodec<B, V> codec) {
        return new ContextualStreamCodec<B, CONTEXT, Optional<V>>(){

            @Override
            public Optional<V> decode(B buffer, CONTEXT context) {
                return buffer.readBoolean() ? Optional.of(codec.decode(buffer)) : Optional.empty();
            }

            @Override
            public void encode(B buffer, CONTEXT context, Optional<V> value) {
                if (value.isPresent()) {
                    buffer.writeBoolean(true);
                    codec.encode(buffer, value.get());
                } else {
                    buffer.writeBoolean(false);
                }
            }
        };
    }

    public static <B extends ByteBuf, CONTEXT, V> ContextualStreamCodec<B, CONTEXT, Optional<V>> optional(final ContextualStreamCodec<B, CONTEXT, V> codec) {
        return new ContextualStreamCodec<B, CONTEXT, Optional<V>>(){

            @Override
            public Optional<V> decode(B buffer, CONTEXT context) {
                return buffer.readBoolean() ? Optional.of(codec.decode(buffer, context)) : Optional.empty();
            }

            @Override
            public void encode(B buffer, CONTEXT context, Optional<V> value) {
                if (value.isPresent()) {
                    buffer.writeBoolean(true);
                    codec.encode(buffer, context, value.get());
                } else {
                    buffer.writeBoolean(false);
                }
            }
        };
    }

    default public <O> ContextualStreamCodec<B, CONTEXT, O> map(final Function<? super V, ? extends O> factory, final Function<? super O, ? extends V> getter) {
        return new ContextualStreamCodec<B, CONTEXT, O>(){

            @Override
            public O decode(B buffer, CONTEXT context) {
                return factory.apply(ContextualStreamCodec.this.decode(buffer, context));
            }

            @Override
            public void encode(B buffer, CONTEXT context, O value) {
                ContextualStreamCodec.this.encode(buffer, context, getter.apply(value));
            }
        };
    }

    default public <O> ContextualStreamCodec<B, CONTEXT, O> map(final Function<? super V, ? extends O> factory, final BiFunction<? super O, CONTEXT, ? extends V> getter) {
        return new ContextualStreamCodec<B, CONTEXT, O>(){

            @Override
            public O decode(B buffer, CONTEXT context) {
                return factory.apply(ContextualStreamCodec.this.decode(buffer, context));
            }

            @Override
            public void encode(B buffer, CONTEXT context, O value) {
                ContextualStreamCodec.this.encode(buffer, context, getter.apply(value, context));
            }
        };
    }

    default public <O> ContextualStreamCodec<B, CONTEXT, O> map(final BiFunction<? super V, CONTEXT, ? extends O> factory, final Function<? super O, ? extends V> getter) {
        return new ContextualStreamCodec<B, CONTEXT, O>(){

            @Override
            public O decode(B buffer, CONTEXT context) {
                return factory.apply(ContextualStreamCodec.this.decode(buffer, context), context);
            }

            @Override
            public void encode(B buffer, CONTEXT context, O value) {
                ContextualStreamCodec.this.encode(buffer, context, getter.apply(value));
            }
        };
    }

    default public <O> ContextualStreamCodec<B, CONTEXT, O> map(final BiFunction<? super V, CONTEXT, ? extends O> factory, final BiFunction<? super O, CONTEXT, ? extends V> getter) {
        return new ContextualStreamCodec<B, CONTEXT, O>(){

            @Override
            public O decode(B buffer, CONTEXT context) {
                return factory.apply(ContextualStreamCodec.this.decode(buffer, context), context);
            }

            @Override
            public void encode(B buffer, CONTEXT context, O value) {
                ContextualStreamCodec.this.encode(buffer, context, getter.apply(value, context));
            }
        };
    }

    public static <B, CONTEXT, C, T1> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec, final Function<C, T1> getter, final Function<T1, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec.decode(buffer, context);
                return factory.apply(t1);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec.encode(buffer, context, getter.apply(value));
            }
        };
    }

    public static <B, CONTEXT, C, T1, T2> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec1, final Function<C, T1> getter1, final ContextualStreamCodec<? super B, CONTEXT, T2> codec2, final Function<C, T2> getter2, final BiFunction<T1, T2, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec1.decode(buffer, context);
                Object t2 = codec2.decode(buffer, context);
                return factory.apply(t1, t2);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec1.encode(buffer, context, getter1.apply(value));
                codec2.encode(buffer, context, getter2.apply(value));
            }
        };
    }

    public static <B, CONTEXT, C, T1, T2, T3> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec1, final Function<C, T1> getter1, final ContextualStreamCodec<? super B, CONTEXT, T2> codec2, final Function<C, T2> getter2, final ContextualStreamCodec<? super B, CONTEXT, T3> codec3, final Function<C, T3> getter3, final Function3<T1, T2, T3, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec1.decode(buffer, context);
                Object t2 = codec2.decode(buffer, context);
                Object t3 = codec3.decode(buffer, context);
                return factory.apply(t1, t2, t3);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec1.encode(buffer, context, getter1.apply(value));
                codec2.encode(buffer, context, getter2.apply(value));
                codec3.encode(buffer, context, getter3.apply(value));
            }
        };
    }

    public static <B, CONTEXT, C, T1, T2, T3, T4> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec1, final Function<C, T1> getter1, final ContextualStreamCodec<? super B, CONTEXT, T2> codec2, final Function<C, T2> getter2, final ContextualStreamCodec<? super B, CONTEXT, T3> codec3, final Function<C, T3> getter3, final ContextualStreamCodec<? super B, CONTEXT, T4> codec4, final Function<C, T4> getter4, final Function4<T1, T2, T3, T4, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec1.decode(buffer, context);
                Object t2 = codec2.decode(buffer, context);
                Object t3 = codec3.decode(buffer, context);
                Object t4 = codec4.decode(buffer, context);
                return factory.apply(t1, t2, t3, t4);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec1.encode(buffer, context, getter1.apply(value));
                codec2.encode(buffer, context, getter2.apply(value));
                codec3.encode(buffer, context, getter3.apply(value));
                codec4.encode(buffer, context, getter4.apply(value));
            }
        };
    }

    public static <B, CONTEXT, C, T1, T2, T3, T4, T5> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec1, final Function<C, T1> getter1, final ContextualStreamCodec<? super B, CONTEXT, T2> codec2, final Function<C, T2> getter2, final ContextualStreamCodec<? super B, CONTEXT, T3> codec3, final Function<C, T3> getter3, final ContextualStreamCodec<? super B, CONTEXT, T4> codec4, final Function<C, T4> getter4, final ContextualStreamCodec<? super B, CONTEXT, T5> codec5, final Function<C, T5> getter5, final Function5<T1, T2, T3, T4, T5, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec1.decode(buffer, context);
                Object t2 = codec2.decode(buffer, context);
                Object t3 = codec3.decode(buffer, context);
                Object t4 = codec4.decode(buffer, context);
                Object t5 = codec5.decode(buffer, context);
                return factory.apply(t1, t2, t3, t4, t5);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec1.encode(buffer, context, getter1.apply(value));
                codec2.encode(buffer, context, getter2.apply(value));
                codec3.encode(buffer, context, getter3.apply(value));
                codec4.encode(buffer, context, getter4.apply(value));
                codec5.encode(buffer, context, getter5.apply(value));
            }
        };
    }

    public static <B, CONTEXT, C, T1, T2, T3, T4, T5, T6> ContextualStreamCodec<B, CONTEXT, C> composite(final ContextualStreamCodec<? super B, CONTEXT, T1> codec1, final Function<C, T1> getter1, final ContextualStreamCodec<? super B, CONTEXT, T2> codec2, final Function<C, T2> getter2, final ContextualStreamCodec<? super B, CONTEXT, T3> codec3, final Function<C, T3> getter3, final ContextualStreamCodec<? super B, CONTEXT, T4> codec4, final Function<C, T4> getter4, final ContextualStreamCodec<? super B, CONTEXT, T5> codec5, final Function<C, T5> getter5, final ContextualStreamCodec<? super B, CONTEXT, T6> codec6, final Function<C, T6> getter6, final Function6<T1, T2, T3, T4, T5, T6, C> factory) {
        return new ContextualStreamCodec<B, CONTEXT, C>(){

            @Override
            public C decode(B buffer, CONTEXT context) {
                Object t1 = codec1.decode(buffer, context);
                Object t2 = codec2.decode(buffer, context);
                Object t3 = codec3.decode(buffer, context);
                Object t4 = codec4.decode(buffer, context);
                Object t5 = codec5.decode(buffer, context);
                Object t6 = codec6.decode(buffer, context);
                return factory.apply(t1, t2, t3, t4, t5, t6);
            }

            @Override
            public void encode(B buffer, CONTEXT context, C value) {
                codec1.encode(buffer, context, getter1.apply(value));
                codec2.encode(buffer, context, getter2.apply(value));
                codec3.encode(buffer, context, getter3.apply(value));
                codec4.encode(buffer, context, getter4.apply(value));
                codec5.encode(buffer, context, getter5.apply(value));
                codec6.encode(buffer, context, getter6.apply(value));
            }
        };
    }
}

