/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class OptionalFieldDecoder<A>
extends MapDecoder.Implementation<Optional<A>> {
    private final String name;
    private final Decoder<A> elementDecoder;
    private final boolean lenient;

    public OptionalFieldDecoder(String name, Decoder<A> elementDecoder, boolean lenient) {
        this.name = name;
        this.elementDecoder = elementDecoder;
        this.lenient = lenient;
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        DataResult parsed = this.elementDecoder.parse(ops, value);
        if (parsed.isError() && this.lenient) {
            return DataResult.success(Optional.empty());
        }
        return parsed.map(Optional::of).setPartial((Object)parsed.resultOrPartial());
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OptionalFieldDecoder that = (OptionalFieldDecoder)((Object)o);
        return Objects.equals(this.name, that.name) && Objects.equals(this.elementDecoder, that.elementDecoder) && this.lenient == that.lenient;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.elementDecoder, this.lenient);
    }

    public String toString() {
        return "OptionalFieldDecoder[" + this.name + ": " + String.valueOf(this.elementDecoder) + "]";
    }
}

