/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.codec;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.petrolpark.core.codec.OptionalFieldDecoder;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class RecordDecoderBuilder<O, F>
implements App<Mu<O>, F> {
    private final MapDecoder<F> decoder;

    public static <O, F> RecordDecoderBuilder<O, F> unbox(App<Mu<O>, F> box) {
        return (RecordDecoderBuilder)box;
    }

    private RecordDecoderBuilder(MapDecoder<F> decoder) {
        this.decoder = decoder;
    }

    public static <O> Instance<O> instance() {
        return new Instance();
    }

    public static <O, F> RecordDecoderBuilder<O, F> of(String name, Codec<F> fieldCodec) {
        return RecordDecoderBuilder.of(fieldCodec.fieldOf(name));
    }

    public static <O, F> RecordDecoderBuilder<O, F> of(MapDecoder<F> decoder) {
        return new RecordDecoderBuilder<O, F>(decoder);
    }

    public static <O, F> RecordDecoderBuilder<O, Optional<F>> ofOptional(Decoder<F> elementDecoder, String name) {
        return RecordDecoderBuilder.ofOptional(elementDecoder, name, false);
    }

    public static <O, F> RecordDecoderBuilder<O, Optional<F>> ofOptional(Decoder<F> elementDecoder, String name, boolean lenient) {
        return RecordDecoderBuilder.of(new OptionalFieldDecoder<F>(name, elementDecoder, lenient));
    }

    public static <O, F> RecordDecoderBuilder<O, F> ofOptional(Decoder<F> elementDecoder, String name, F defaultValue) {
        return RecordDecoderBuilder.ofOptional(elementDecoder, name, defaultValue, false);
    }

    public static <O, F> RecordDecoderBuilder<O, F> ofOptional(Decoder<F> elementDecoder, String name, F defaultValue, boolean lenient) {
        return RecordDecoderBuilder.of(new OptionalFieldDecoder<F>(name, elementDecoder, lenient).map(optional -> optional.orElse(defaultValue)));
    }

    public static <O, F> RecordDecoderBuilder<O, F> point(F instance) {
        return new RecordDecoderBuilder<O, F>(Decoder.unit(instance));
    }

    public static <O, F> RecordDecoderBuilder<O, F> stable(F instance) {
        return RecordDecoderBuilder.point(instance, Lifecycle.stable());
    }

    public static <O, F> RecordDecoderBuilder<O, F> deprecated(F instance, int since) {
        return RecordDecoderBuilder.point(instance, Lifecycle.deprecated((int)since));
    }

    public static <O, F> RecordDecoderBuilder<O, F> point(F instance, Lifecycle lifecycle) {
        return new RecordDecoderBuilder<O, F>(Decoder.unit(instance).withLifecycle(lifecycle));
    }

    public static <O> Decoder<O> create(Function<Instance<O>, ? extends App<Mu<O>, O>> builder) {
        return RecordDecoderBuilder.build(builder.apply(RecordDecoderBuilder.instance())).decoder();
    }

    public static <O> MapDecoder<O> mapDecoder(Function<Instance<O>, ? extends App<Mu<O>, O>> builder) {
        return RecordDecoderBuilder.build(builder.apply(RecordDecoderBuilder.instance()));
    }

    public static <O> MapDecoder<O> build(App<Mu<O>, O> builderBox) {
        final RecordDecoderBuilder<O, O> builder = RecordDecoderBuilder.unbox(builderBox);
        return new MapDecoder.Implementation<O>(){

            public <T> DataResult<O> decode(DynamicOps<T> ops, MapLike<T> input) {
                return builder.decoder.decode(ops, input);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return builder.decoder.keys(ops);
            }

            public String toString() {
                return "RecordCodec[" + String.valueOf(builder.decoder) + "]";
            }
        };
    }

    public static final class Instance<O>
    implements Applicative<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, Mu<O>> {
        public <A> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A> stable(A a) {
            return RecordDecoderBuilder.stable(a);
        }

        public <A> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A> deprecated(A a, int since) {
            return RecordDecoderBuilder.deprecated(a, since);
        }

        public <A> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A> point(A a, Lifecycle lifecycle) {
            return RecordDecoderBuilder.point(a, lifecycle);
        }

        public <A> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A> point(A a) {
            return RecordDecoderBuilder.point(a);
        }

        public <A, R> Function<App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A>, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, R>> lift1(App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, Function<A, R>> function) {
            return fa -> {
                final RecordDecoderBuilder f = RecordDecoderBuilder.unbox(function);
                final RecordDecoderBuilder a = RecordDecoderBuilder.unbox(fa);
                return new RecordDecoderBuilder(new MapDecoder.Implementation<R>(this){

                    public <T> DataResult<R> decode(DynamicOps<T> ops, MapLike<T> input) {
                        return a.decoder.decode(ops, input).flatMap(ar -> f2.decoder.decode(ops, input).map(fr -> fr.apply(ar)));
                    }

                    public <T> Stream<T> keys(DynamicOps<T> ops) {
                        return Stream.concat(a.decoder.keys(ops), f.decoder.keys(ops));
                    }

                    public String toString() {
                        return String.valueOf(f.decoder) + " * " + String.valueOf(a.decoder);
                    }
                });
            };
        }

        public <A, B, R> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, R> ap2(App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, BiFunction<A, B, R>> func, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, A> a, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, B> b) {
            final RecordDecoderBuilder<O, BiFunction<A, B, R>> function = RecordDecoderBuilder.unbox(func);
            final RecordDecoderBuilder<O, A> fa = RecordDecoderBuilder.unbox(a);
            final RecordDecoderBuilder<O, B> fb = RecordDecoderBuilder.unbox(b);
            return new RecordDecoderBuilder(new MapDecoder.Implementation<R>(this){

                public <T> DataResult<R> decode(DynamicOps<T> ops, MapLike<T> input) {
                    return DataResult.unbox((App)DataResult.instance().ap2((App)function.decoder.decode(ops, input), (App)fa.decoder.decode(ops, input), (App)fb.decoder.decode(ops, input)));
                }

                public <T> Stream<T> keys(DynamicOps<T> ops) {
                    return Stream.of(function.decoder.keys(ops), fa.decoder.keys(ops), fb.decoder.keys(ops)).flatMap(Function.identity());
                }

                public String toString() {
                    return String.valueOf(function.decoder) + " * " + String.valueOf(fa.decoder) + " * " + String.valueOf(fb.decoder);
                }
            });
        }

        public <T1, T2, T3, R> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, R> ap3(App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, Function3<T1, T2, T3, R>> func, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T1> t1, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T2> t2, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T3> t3) {
            final RecordDecoderBuilder<O, Function3<T1, T2, T3, R>> function = RecordDecoderBuilder.unbox(func);
            final RecordDecoderBuilder<O, T1> f1 = RecordDecoderBuilder.unbox(t1);
            final RecordDecoderBuilder<O, T2> f2 = RecordDecoderBuilder.unbox(t2);
            final RecordDecoderBuilder<O, T3> f3 = RecordDecoderBuilder.unbox(t3);
            return new RecordDecoderBuilder(new MapDecoder.Implementation<R>(this){

                public <T> DataResult<R> decode(DynamicOps<T> ops, MapLike<T> input) {
                    return DataResult.unbox((App)DataResult.instance().ap3((App)function.decoder.decode(ops, input), (App)f1.decoder.decode(ops, input), (App)f2.decoder.decode(ops, input), (App)f3.decoder.decode(ops, input)));
                }

                public <T> Stream<T> keys(DynamicOps<T> ops) {
                    return Stream.of(function.decoder.keys(ops), f1.decoder.keys(ops), f2.decoder.keys(ops), f3.decoder.keys(ops)).flatMap(Function.identity());
                }

                public String toString() {
                    return String.valueOf(function.decoder) + " * " + String.valueOf(f1.decoder) + " * " + String.valueOf(f2.decoder) + " * " + String.valueOf(f3.decoder);
                }
            });
        }

        public <T1, T2, T3, T4, R> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, R> ap4(App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, Function4<T1, T2, T3, T4, R>> func, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T1> t1, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T2> t2, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T3> t3, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T4> t4) {
            final RecordDecoderBuilder<O, Function4<T1, T2, T3, T4, R>> function = RecordDecoderBuilder.unbox(func);
            final RecordDecoderBuilder<O, T1> f1 = RecordDecoderBuilder.unbox(t1);
            final RecordDecoderBuilder<O, T2> f2 = RecordDecoderBuilder.unbox(t2);
            final RecordDecoderBuilder<O, T3> f3 = RecordDecoderBuilder.unbox(t3);
            final RecordDecoderBuilder<O, T4> f4 = RecordDecoderBuilder.unbox(t4);
            return new RecordDecoderBuilder(new MapDecoder.Implementation<R>(this){

                public <T> DataResult<R> decode(DynamicOps<T> ops, MapLike<T> input) {
                    return DataResult.unbox((App)DataResult.instance().ap4((App)function.decoder.decode(ops, input), (App)f1.decoder.decode(ops, input), (App)f2.decoder.decode(ops, input), (App)f3.decoder.decode(ops, input), (App)f4.decoder.decode(ops, input)));
                }

                public <T> Stream<T> keys(DynamicOps<T> ops) {
                    return Stream.of(function.decoder.keys(ops), f1.decoder.keys(ops), f2.decoder.keys(ops), f3.decoder.keys(ops), f4.decoder.keys(ops)).flatMap(Function.identity());
                }

                public String toString() {
                    return String.valueOf(function.decoder) + " * " + String.valueOf(f1.decoder) + " * " + String.valueOf(f2.decoder) + " * " + String.valueOf(f3.decoder) + " * " + String.valueOf(f4.decoder);
                }
            });
        }

        public <T, R> App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, R> map(Function<? super T, ? extends R> func, App<com.petrolpark.core.codec.RecordDecoderBuilder$Mu<O>, T> ts) {
            RecordDecoderBuilder<O, T> unbox = RecordDecoderBuilder.unbox(ts);
            return new RecordDecoderBuilder(unbox.decoder.map(func));
        }

        private static final class Mu<O>
        implements Applicative.Mu {
            private Mu() {
            }
        }
    }

    public static final class Mu<O>
    implements K1 {
    }
}

