/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.contamination;

import com.petrolpark.PetrolparkTags;
import com.petrolpark.core.contamination.BuiltInRegistryContaminable;
import com.petrolpark.core.contamination.Contaminable;
import com.petrolpark.core.contamination.FluidContamination;
import com.petrolpark.core.contamination.IncontaminableContamination;
import com.petrolpark.core.contamination.ItemContamination;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class Contaminables {
    protected static final List<Contaminable<?, ?>> CONTAMINABLES = new ArrayList();
    public static final Contaminable.GenericContaminable GENERIC = new Contaminable.GenericContaminable();
    public static final Contaminable.GenericContaminable NOT = new Contaminable.GenericContaminable(){

        public IncontaminableContamination getContamination(Object stack) {
            return IncontaminableContamination.INSTANCE;
        }
    };
    public static final Contaminable<Item, ItemStack> ITEM = new BuiltInRegistryContaminable<Item, ItemStack>((Registry)BuiltInRegistries.ITEM){

        @Override
        public boolean isContaminable(Item object) {
            return object instanceof BlockItem ? PetrolparkTags.Items.CONTAMINABLE_BLOCKS.matches(object) : !PetrolparkTags.Items.INCONTAMINABLE.matches(object);
        }

        @Override
        public boolean isContaminableStack(ItemStack stack) {
            return !stack.isEmpty() && this.isContaminable(stack.getItem());
        }

        public ItemContamination getContamination(Object stack) {
            ItemStack itemStack;
            if (stack instanceof ItemStack && this.isContaminableStack(itemStack = (ItemStack)stack)) {
                return new ItemContamination(itemStack);
            }
            return null;
        }
    };
    public static final Contaminable<Fluid, FluidStack> FLUID = new BuiltInRegistryContaminable<Fluid, FluidStack>((Registry)BuiltInRegistries.FLUID){

        @Override
        public boolean isContaminable(Fluid object) {
            return !PetrolparkTags.Fluids.INCONTAMINABLE.matches(object);
        }

        @Override
        public boolean isContaminableStack(FluidStack stack) {
            return !stack.isEmpty() && this.isContaminable(stack.getFluid());
        }

        public FluidContamination getContamination(Object stack) {
            FluidStack fluidStack;
            if (stack instanceof FluidStack && this.isContaminableStack(fluidStack = (FluidStack)stack)) {
                return new FluidContamination(fluidStack);
            }
            return null;
        }
    };

    public static void register(Contaminable<?, ?> contaminable) {
        CONTAMINABLES.add(contaminable);
    }

    public static Stream<Contaminable<?, ?>> streamContaminables() {
        return CONTAMINABLES.stream();
    }

    static {
        Contaminables.register(GENERIC);
        Contaminables.register(NOT);
        Contaminables.register(ITEM);
        Contaminables.register(FLUID);
    }
}

