/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.util.Lang;
import java.lang.runtime.SwitchBootstraps;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract sealed class NumberEstimate {
    public static final NumberEstimate ZERO = NumberEstimate.exactly(0.0f);
    public static final NumberEstimate ONE = NumberEstimate.exactly(1.0f);
    public static final NumberEstimate E = NumberEstimate.exactly((float)Math.E);
    public static final NumberEstimate UNKNOWN = new Unknown();
    public final boolean approximate;

    public static float getMax(LootContext context, NumberProvider provider) {
        return NumberEstimate.getMax(context, provider, 10);
    }

    public static float getMax(LootContext context, NumberProvider provider, int rolls) {
        NumberProvider numberProvider = provider;
        Objects.requireNonNull(numberProvider);
        NumberProvider numberProvider2 = numberProvider;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IEstimableNumberProvider.class, ConstantValue.class, UniformGenerator.class, BinomialDistributionGenerator.class}, (Object)numberProvider2, n)) {
            case 0 -> {
                IEstimableNumberProvider estimable = (IEstimableNumberProvider)numberProvider2;
                yield estimable.getMaxFloat(context);
            }
            case 1 -> {
                ConstantValue constant = (ConstantValue)numberProvider2;
                yield constant.value();
            }
            case 2 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider2;
                yield NumberEstimate.getMax(context, uniform.max(), rolls);
            }
            case 3 -> {
                BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)numberProvider2;
                yield NumberEstimate.getMax(context, binomial.n(), rolls);
            }
            default -> (float)IntStream.range(0, rolls).mapToDouble(i -> provider.getFloat(context)).max().orElse(0.0);
        };
    }

    public static NumberEstimate get(NumberProvider numberProvider) {
        NumberProvider numberProvider2 = numberProvider;
        Objects.requireNonNull(numberProvider2);
        NumberProvider numberProvider3 = numberProvider2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IEstimableNumberProvider.class, ConstantValue.class, UniformGenerator.class, BinomialDistributionGenerator.class}, (Object)numberProvider3, n)) {
            case 0 -> {
                IEstimableNumberProvider estimable = (IEstimableNumberProvider)numberProvider3;
                yield estimable.getEstimate();
            }
            case 1 -> {
                ConstantValue constant = (ConstantValue)numberProvider3;
                yield NumberEstimate.exactly(constant.value());
            }
            case 2 -> {
                UniformGenerator uniform = (UniformGenerator)numberProvider3;
                yield NumberEstimate.ranged(NumberEstimate.get(uniform.min()), NumberEstimate.get(uniform.max()));
            }
            case 3 -> {
                BinomialDistributionGenerator binomial = (BinomialDistributionGenerator)numberProvider3;
                yield NumberEstimate.getBinomial(binomial);
            }
            default -> UNKNOWN;
        };
    }

    public static final NumberEstimate getBinomial(BinomialDistributionGenerator binomial) {
        NumberEstimate n = NumberEstimate.get(binomial.n());
        NumberEstimate p = NumberEstimate.get(binomial.p());
        NumberEstimate mean = n.multiply(p);
        NumberEstimate twoSD = mean.multiply(ONE.subtract(p)).pow(0.5f).multiply(2.0f);
        return NumberEstimate.ranged(mean.subtract(twoSD), mean.add(twoSD), true);
    }

    public static final NumberEstimate exactly(float value) {
        if (value == Float.NaN) {
            return UNKNOWN;
        }
        return new Exact(value, false);
    }

    public static final NumberEstimate approximately(float value) {
        if (value == Float.NaN) {
            return UNKNOWN;
        }
        return new Exact(value, true);
    }

    public static final NumberEstimate ranged(NumberEstimate minEstimate, NumberEstimate maxEstimate) {
        return NumberEstimate.ranged(minEstimate, maxEstimate, false);
    }

    public static final NumberEstimate ranged(NumberEstimate minEstimate, NumberEstimate maxEstimate, boolean approximate) {
        Unknown unknown;
        Range range;
        Exact exact;
        if (minEstimate == UNKNOWN && maxEstimate == UNKNOWN) {
            return UNKNOWN;
        }
        NumberEstimate numberEstimate = minEstimate;
        Objects.requireNonNull(numberEstimate);
        NumberEstimate numberEstimate2 = numberEstimate;
        int n = 0;
        float f = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                exact = (Exact)numberEstimate2;
                yield exact.value;
            }
            case 1 -> {
                range = (Range)numberEstimate2;
                yield range.min;
            }
            case 2 -> {
                unknown = (Unknown)numberEstimate2;
                yield 0.0f;
            }
        };
        NumberEstimate numberEstimate3 = maxEstimate;
        Objects.requireNonNull(numberEstimate3);
        numberEstimate2 = numberEstimate3;
        n = 0;
        return new Range(f, switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                exact = (Exact)numberEstimate2;
                yield exact.value;
            }
            case 1 -> {
                range = (Range)numberEstimate2;
                yield range.max;
            }
            case 2 -> {
                unknown = (Unknown)numberEstimate2;
                yield 0.0f;
            }
        }, approximate || minEstimate.approximate || maxEstimate.approximate);
    }

    public static final NumberEstimate ranged(float min, float max, boolean approximate) {
        if (min == Float.NaN && max == Float.NaN) {
            return UNKNOWN;
        }
        return new Range(min, max, approximate);
    }

    public static final NumberEstimate ranged(float min, float max) {
        return NumberEstimate.ranged(min, max, false);
    }

    protected NumberEstimate(boolean approximate) {
        this.approximate = approximate;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getIntComponent() {
        return this.getComponent(Lang.INT_DF);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getComponent(DecimalFormat var1);

    public abstract float min();

    public abstract float max();

    public abstract NumberEstimate add(NumberEstimate var1);

    public NumberEstimate subtract(NumberEstimate estimate) {
        return this.add(estimate.negative());
    }

    public abstract NumberEstimate add(float var1);

    public abstract NumberEstimate multiply(NumberEstimate var1);

    public NumberEstimate divide(NumberEstimate estimate) {
        return this.multiply(estimate.reciprocal());
    }

    public abstract NumberEstimate multiply(float var1);

    public abstract NumberEstimate reciprocal();

    public abstract NumberEstimate negative();

    public abstract NumberEstimate pow(float var1);

    public abstract NumberEstimate exp();

    public abstract NumberEstimate or(NumberEstimate var1);

    public boolean unknown() {
        return this == UNKNOWN;
    }

    public static final class Exact
    extends NumberEstimate {
        public final float value;

        public Exact(float value, boolean approximate) {
            super(approximate);
            this.value = value;
        }

        @Override
        public Component getComponent(DecimalFormat df) {
            return Component.literal((String)df.format(this.value));
        }

        @Override
        public float min() {
            return this.value;
        }

        @Override
        public float max() {
            return this.value;
        }

        @Override
        public NumberEstimate add(NumberEstimate estimate) {
            NumberEstimate numberEstimate = estimate;
            Objects.requireNonNull(numberEstimate);
            NumberEstimate numberEstimate2 = numberEstimate;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Exact exact = (Exact)numberEstimate2;
                    yield new Exact(this.value + exact.value, this.approximate || estimate.approximate);
                }
                case 1 -> {
                    Range range = (Range)numberEstimate2;
                    yield range.add(this);
                }
                case 2 -> {
                    Unknown unknown = (Unknown)numberEstimate2;
                    yield UNKNOWN;
                }
            };
        }

        @Override
        public NumberEstimate add(float value) {
            return new Exact(this.value + value, this.approximate);
        }

        @Override
        public NumberEstimate multiply(NumberEstimate estimate) {
            NumberEstimate numberEstimate = estimate;
            Objects.requireNonNull(numberEstimate);
            NumberEstimate numberEstimate2 = numberEstimate;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Exact exact = (Exact)numberEstimate2;
                    yield new Exact(this.value * exact.value, this.approximate || estimate.approximate);
                }
                case 1 -> {
                    Range range = (Range)numberEstimate2;
                    yield range.multiply(this);
                }
                case 2 -> {
                    Unknown unknown = (Unknown)numberEstimate2;
                    yield UNKNOWN;
                }
            };
        }

        @Override
        public NumberEstimate multiply(float value) {
            return new Exact(this.value * value, this.approximate);
        }

        @Override
        public NumberEstimate reciprocal() {
            return new Exact(1.0f / this.value, this.approximate);
        }

        @Override
        public NumberEstimate negative() {
            return new Exact(-this.value, this.approximate);
        }

        @Override
        public NumberEstimate pow(float exponent) {
            return new Exact((float)Math.pow(this.value, exponent), this.approximate);
        }

        @Override
        public NumberEstimate exp() {
            return new Exact((float)Math.exp(this.value), this.approximate);
        }

        @Override
        public NumberEstimate or(NumberEstimate estimate) {
            if (estimate instanceof Range) {
                Range range = (Range)estimate;
                return range.or(this);
            }
            if (estimate instanceof Exact) {
                Exact exact = (Exact)estimate;
                return Exact.ranged(Math.min(this.value, exact.value), Math.max(this.value, exact.value), this.approximate || estimate.approximate);
            }
            return UNKNOWN;
        }
    }

    public static final class Range
    extends NumberEstimate {
        public final float min;
        public final float max;

        public Range(float min, float max, boolean approximate) {
            super(approximate);
            this.min = min;
            this.max = max;
        }

        @Override
        public Component getComponent(DecimalFormat df) {
            return Lang.range(this.min, this.max, this.approximate, df);
        }

        @Override
        public float min() {
            return this.min();
        }

        @Override
        public float max() {
            return this.max();
        }

        @Override
        public NumberEstimate add(NumberEstimate estimate) {
            NumberEstimate numberEstimate = estimate;
            Objects.requireNonNull(numberEstimate);
            NumberEstimate numberEstimate2 = numberEstimate;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Exact exact = (Exact)numberEstimate2;
                    yield Range.ranged(this.min + exact.value, this.max + exact.value, this.approximate || estimate.approximate);
                }
                case 1 -> {
                    Range range = (Range)numberEstimate2;
                    yield Range.ranged(this.min + range.min, this.max + range.max, this.approximate || estimate.approximate);
                }
                case 2 -> {
                    Unknown unknown = (Unknown)numberEstimate2;
                    yield UNKNOWN;
                }
            };
        }

        @Override
        public NumberEstimate add(float value) {
            return Range.ranged(this.min + value, this.max + value, this.approximate);
        }

        @Override
        public NumberEstimate multiply(NumberEstimate estimate) {
            NumberEstimate numberEstimate = estimate;
            Objects.requireNonNull(numberEstimate);
            NumberEstimate numberEstimate2 = numberEstimate;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class, Unknown.class}, (Object)numberEstimate2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Exact exact = (Exact)numberEstimate2;
                    yield Range.ranged(this.min * exact.value, this.max * exact.value, this.approximate || estimate.approximate);
                }
                case 1 -> {
                    Range range = (Range)numberEstimate2;
                    yield Range.ranged(this.min * range.min, this.max * range.max, this.approximate || estimate.approximate);
                }
                case 2 -> {
                    Unknown unknown = (Unknown)numberEstimate2;
                    yield UNKNOWN;
                }
            };
        }

        @Override
        public NumberEstimate multiply(float value) {
            return Range.ranged(this.min * value, this.max * value, this.approximate);
        }

        @Override
        public NumberEstimate reciprocal() {
            return Range.ranged(1.0f / this.max, 1.0f / this.min, this.approximate);
        }

        @Override
        public NumberEstimate negative() {
            return Range.ranged(-this.max, -this.min, this.approximate);
        }

        @Override
        public NumberEstimate pow(float exponent) {
            float a = (float)Math.pow(this.min, exponent);
            float b = (float)Math.pow(this.max, exponent);
            return Range.ranged(Math.min(a, b), Math.min(a, b), this.approximate);
        }

        @Override
        public NumberEstimate exp() {
            return Range.ranged((float)Math.exp(this.min), (float)Math.exp(this.max), this.approximate);
        }

        @Override
        public NumberEstimate or(NumberEstimate estimate) {
            if (estimate instanceof Exact) {
                Exact exact = (Exact)estimate;
                if (exact.value > this.max) {
                    return Range.ranged(this.min, exact.value, this.approximate || estimate.approximate);
                }
                if (exact.value < this.min) {
                    return Range.ranged(exact.value, this.max, this.approximate || estimate.approximate);
                }
                return this;
            }
            if (estimate instanceof Range) {
                Range range = (Range)estimate;
                return Range.ranged(Math.min(this.min, range.min), Math.max(this.max, range.max), this.approximate || estimate.approximate);
            }
            return UNKNOWN;
        }
    }

    public static final class Unknown
    extends NumberEstimate {
        public Unknown() {
            super(true);
        }

        @Override
        public Component getComponent(DecimalFormat df) {
            return Lang.unknownRange();
        }

        @Override
        public float min() {
            return Float.NaN;
        }

        @Override
        public float max() {
            return Float.NaN;
        }

        @Override
        public NumberEstimate add(NumberEstimate estimate) {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate add(float value) {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate multiply(NumberEstimate estimate) {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate multiply(float value) {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate reciprocal() {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate negative() {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate pow(float exponent) {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate exp() {
            return UNKNOWN;
        }

        @Override
        public NumberEstimate or(NumberEstimate estimate) {
            return UNKNOWN;
        }
    }
}

