/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.loot.numberprovider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkNumberProviderTypes;
import com.petrolpark.core.data.loot.numberprovider.IEstimableNumberProvider;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record PolynomialNumberProvider(NumberProvider value, List<NumberProvider> coefficients) implements IEstimableNumberProvider
{
    public static final MapCodec<PolynomialNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("value").forGetter(PolynomialNumberProvider::value), (App)NumberProviders.CODEC.listOf().fieldOf("coefficients").forGetter(PolynomialNumberProvider::coefficients)).apply((Applicative)instance, PolynomialNumberProvider::new));

    public float getFloat(@Nonnull LootContext lootContext) {
        float total = 0.0f;
        float value = this.value().getFloat(lootContext);
        int power = 0;
        for (NumberProvider coeff : this.coefficients()) {
            total = (float)((double)total + (double)coeff.getFloat(lootContext) * Math.pow(value, power));
            ++power;
        }
        return total;
    }

    @Override
    public NumberEstimate getEstimate() {
        NumberEstimate total = NumberEstimate.ZERO;
        NumberEstimate value = NumberEstimate.get(this.value());
        int power = 0;
        for (NumberProvider coeff : this.coefficients()) {
            total = total.add(NumberEstimate.get(coeff).multiply(value.pow(power)));
            ++power;
        }
        return total;
    }

    @Override
    public float getMaxFloat(LootContext context) {
        float total = 0.0f;
        float value = NumberEstimate.getMax(context, this.value());
        int power = 0;
        for (NumberProvider coeff : this.coefficients()) {
            total = (float)((double)total + (double)NumberEstimate.getMax(context, coeff) * Math.pow(value, power));
            ++power;
        }
        return total;
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)PetrolparkNumberProviderTypes.POLYNOMIAL.get();
    }
}

