/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.loot.ILootTableAccessor;
import com.petrolpark.core.data.reward.entity.AbstractGiveItemsEntityReward;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.util.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;

public class GiveLootEntityReward
extends AbstractGiveItemsEntityReward
implements ILootTableAccessor {
    public static final MapCodec<GiveLootEntityReward> CODEC = RecordCodecBuilder.mapCodec(instance -> ILootTableAccessor.lootTableField(instance).and(GiveLootEntityReward.lateItemFunctionsField(instance).t1()).apply((Applicative)instance, GiveLootEntityReward::new));
    protected final Either<ResourceKey<LootTable>, LootTable> lootTable;

    public GiveLootEntityReward(Either<ResourceKey<LootTable>, LootTable> lootTable, List<LootItemFunction> functions) {
        super(functions);
        this.lootTable = lootTable;
    }

    @Override
    public Either<ResourceKey<LootTable>, LootTable> lootTable() {
        return this.lootTable;
    }

    @Override
    public Stream<ItemStack> streamStacks(Entity recipient, LootContext context) {
        ArrayList stacks = new ArrayList();
        this.getLootTable(context).getRandomItems(context, stacks::add);
        return stacks.stream();
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add((Component)this.lootTable.map(key -> this.translateSimple(Lang.loot(key.location())), table -> this.translate("unknown_table", new Object[0])));
    }

    @Override
    public EntityRewardType getType() {
        return (EntityRewardType)PetrolparkRewardTypes.GIVE_LOOT.get();
    }
}

