/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.reward.entity.EntityRewardType;
import com.petrolpark.core.data.reward.entity.IEntityReward;
import com.petrolpark.util.Lang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.storage.loot.LootContext;

public record UnlockTradeEntityReward(MerchantOffer trade) implements IEntityReward
{
    public static final MapCodec<UnlockTradeEntityReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MerchantOffer.CODEC.fieldOf("trade").forGetter(UnlockTradeEntityReward::trade)).apply((Applicative)instance, UnlockTradeEntityReward::new));

    @Override
    public void reward(Entity entity, LootContext context, float multiplier) {
        if (entity instanceof Merchant) {
            Merchant merchant = (Merchant)entity;
            merchant.getOffers().add((Object)this.trade);
        }
    }

    @Override
    public void render(GuiGraphics graphics) {
        throw new UnsupportedOperationException("Unimplemented method 'render'");
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add(this.translateSimple(new Object[0])).indent().add(this.trade().getResult().getHoverName()).unindent().add(this.translate("buying", new Object[0])).indent().add(this.trade().getCostA().getHoverName());
        if (!this.trade().getCostB().isEmpty()) {
            builder.add(this.trade().getCostB().getHoverName());
        }
        builder.unindent();
    }

    @Override
    public EntityRewardType getType() {
        return (EntityRewardType)PetrolparkRewardTypes.UNLOCK_TRADE.get();
    }
}

