/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.data.reward.team;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkRewardTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.data.reward.entity.IEntityReward;
import com.petrolpark.core.data.reward.team.ITeamReward;
import com.petrolpark.core.data.reward.team.TeamRewardType;
import com.petrolpark.core.team.ITeam;
import com.petrolpark.util.Lang;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record MembersTeamReward(IEntityReward reward, Either<NumberProvider, NumberProvider> who, boolean random) implements ITeamReward
{
    public static final MapCodec<MembersTeamReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IEntityReward.CODEC.fieldOf("reward").forGetter(MembersTeamReward::reward), (App)Codec.mapEither((MapCodec)NumberProviders.CODEC.fieldOf("count"), (MapCodec)NumberProviders.CODEC.optionalFieldOf("proportion", (Object)ConstantValue.exactly((float)1.0f))).forGetter(MembersTeamReward::who), (App)Codec.BOOL.optionalFieldOf("random", (Object)false).forGetter(MembersTeamReward::random)).apply((Applicative)instance, MembersTeamReward::new));
    public static final Codec<MembersTeamReward> INLINE_CODEC = IEntityReward.CODEC.xmap(entityReward -> new MembersTeamReward((IEntityReward)entityReward, (Either<NumberProvider, NumberProvider>)Either.right((Object)ConstantValue.exactly((float)1.0f)), false), MembersTeamReward::reward);

    @Override
    public void reward(ITeam team, LootContext context, float multiplier) {
        int count = (Integer)this.who.map(absoluteCount -> Mth.clamp((int)absoluteCount.getInt(context), (int)0, (int)team.memberCount()), proportion -> (int)(Mth.clamp((float)proportion.getFloat(context), (float)0.0f, (float)1.0f) * (float)team.memberCount()));
        if (count == 0) {
            return;
        }
        List members = team.streamMembers().collect(Collectors.toList());
        if (count < team.memberCount() && this.random) {
            Collections.shuffle(members);
        }
        for (int i = 0; i < count && i < members.size(); ++i) {
            this.reward.reward((Entity)members.get(i), context, multiplier);
        }
    }

    @Override
    public void render(GuiGraphics graphics) {
        this.reward.render(graphics);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder builder) {
        builder.add((Component)this.who.map(count -> this.translate("count", NumberEstimate.get(count).getIntComponent()), proportion -> NumberEstimate.get(proportion).min() == 1.0f ? this.translate("all", new Object[0]) : this.translate("percentage", NumberEstimate.get(proportion).multiply(100.0f).getIntComponent())));
        builder.indent();
        this.reward().addToDescription(builder);
        builder.unindent();
    }

    @Override
    public TeamRewardType getType() {
        return (TeamRewardType)PetrolparkRewardTypes.MEMBERS.get();
    }
}

