/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.inventory.extended;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.petrolpark.Petrolpark;
import com.petrolpark.PetrolparkKeys;
import com.petrolpark.client.rendering.PetrolparkGuiTexture;
import com.petrolpark.client.rendering.PetrolparkNineSlices;
import com.petrolpark.config.PetrolparkConfigs;
import com.petrolpark.core.inventory.extended.ExtendedInventory;
import com.petrolpark.core.inventory.extended.ExtraInventorySizeChangePacket;
import com.petrolpark.core.inventory.extended.IExtendedInventoryMenu;
import com.petrolpark.core.inventory.extended.IExtendedInventoryScreen;
import com.petrolpark.core.inventory.extended.RequestInventoryFullStatePacket;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Experimental
public class ExtendedInventoryClientHandler {
    private static final List<KeyMapping> HOTBAR_KEYS = new ArrayList<KeyMapping>(17);
    private static boolean HOTBAR_KEYS_INITIALIZED = false;
    private ExtraInventoryClientSettings settings = null;
    public static final int INVENTORY_PADDING = 7;
    public static final int INVENTORY_SPACING = 4;
    public static final int INVENTORY_HOTBAR_SPACING = 4;
    public AbstractContainerScreen<?> currentScreen = null;
    private Rect2i leftHotbar = null;
    private Rect2i rightHotbar = null;
    private Rect2i combinedInventoryHotbar = null;
    private Rect2i inventory = null;
    private List<Rect2i> extraGuiAreas = Collections.emptyList();

    @SubscribeEvent
    public final void onClientTick(ClientTickEvent.Pre event) {
        if (!ExtendedInventory.enabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)mc.player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        ExtraInventoryClientSettings currentSettings = this.getExtraInventoryClientSettings();
        if (!currentSettings.equals(this.settings)) {
            this.settings = currentSettings;
            ExtendedInventoryClientHandler.refreshClientInventoryMenu(inv);
        }
        if (!HOTBAR_KEYS_INITIALIZED) {
            Collections.addAll(HOTBAR_KEYS, mc.options.keyHotbarSlots);
            Collections.addAll(HOTBAR_KEYS, PetrolparkKeys.HOTBAR_SLOT_9.keybind, PetrolparkKeys.HOTBAR_SLOT_10.keybind, PetrolparkKeys.HOTBAR_SLOT_11.keybind, PetrolparkKeys.HOTBAR_SLOT_12.keybind, PetrolparkKeys.HOTBAR_SLOT_13.keybind, PetrolparkKeys.HOTBAR_SLOT_14.keybind, PetrolparkKeys.HOTBAR_SLOT_15.keybind, PetrolparkKeys.HOTBAR_SLOT_16.keybind);
            HOTBAR_KEYS_INITIALIZED = true;
        }
        if (mc.getOverlay() != null || mc.screen != null || mc.options.keyLoadHotbarActivator.isDown() || mc.options.keySaveHotbarActivator.isDown()) {
            return;
        }
        for (int i = 0; i < inv.getHotbarSize(); ++i) {
            if (!HOTBAR_KEYS.get(i).consumeClick()) continue;
            int slot = i - ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots());
            if (slot < 0) {
                slot += inv.getHotbarSize();
            }
            inv.selected = inv.getSlotIndex(slot);
        }
    }

    public static void refreshClientInventoryMenu(ExtendedInventory inv) {
        int rightY;
        int rightX;
        int leftY;
        int leftX;
        int invY;
        int invX;
        Rect2i inventory;
        Rect2i screenArea = new Rect2i(0, 0, 176, 166);
        Rect2i leftHotbar = ExtendedInventoryClientHandler.getLeftHotbarLocation(inv, screenArea, 142);
        Rect2i rightHotbar = ExtendedInventoryClientHandler.getRightHotbarLocation(inv, screenArea, 142);
        Rect2i combinedInventoryHotbar = ExtendedInventoryClientHandler.getCombinedInventoryHotbarLocation(inv, screenArea, 142);
        Rect2i rect2i = inventory = combinedInventoryHotbar == null ? ExtendedInventoryClientHandler.getInventoryLocation(inv, screenArea, 142) : combinedInventoryHotbar;
        if (inventory == null) {
            invX = 0;
            invY = 0;
        } else {
            invX = inventory.getX();
            invY = inventory.getY();
        }
        if (leftHotbar != null) {
            leftX = leftHotbar.getX() + 7;
            leftY = leftHotbar.getY() + 7;
        } else {
            leftX = 0;
            leftY = 0;
        }
        if (rightHotbar != null) {
            rightX = rightHotbar.getX() + 7;
            rightY = rightHotbar.getY() + 7;
        } else {
            rightX = 0;
            rightY = 0;
        }
        ExtendedInventory.refreshPlayerInventoryMenu(inv.player, ExtendedInventoryClientHandler.getExtraInventoryWidth(), invX + 7, invY + 7, ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots()), leftX, leftY, rightX, rightY);
    }

    public static void handleExtendedInventorySizeChange(ExtraInventorySizeChangePacket packet) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)mc.player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        inv.setExtraInventorySize(packet.extraInventorySize());
        inv.setExtraHotbarSlots(packet.extraHotbarSlots());
        ExtendedInventoryClientHandler.refreshClientInventoryMenu(inv);
        if (packet.requestFullState()) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)RequestInventoryFullStatePacket.INSTANCE);
        }
    }

    public static final int getLeftExtraHotbarSlots(int totalExtraHotbarSlots) {
        if (totalExtraHotbarSlots == 0) {
            return 0;
        }
        switch (ExtendedInventoryClientHandler.getExtraHotbarSlotLocations().ordinal()) {
            case 0: {
                return totalExtraHotbarSlots;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return totalExtraHotbarSlots % 2 + totalExtraHotbarSlots / 2;
            }
            case 3: {
                return totalExtraHotbarSlots / 2;
            }
            case 4: {
                return Math.min(totalExtraHotbarSlots, ExtendedInventoryClientHandler.getExtraHotbarPrioritySlots());
            }
            case 5: {
                return Math.max(0, totalExtraHotbarSlots - ExtendedInventoryClientHandler.getExtraHotbarPrioritySlots());
            }
        }
        return 0;
    }

    public static final int getRightExtraHotbarSlots(int totalExtraHotbarSlots) {
        return totalExtraHotbarSlots - ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(totalExtraHotbarSlots);
    }

    public static final boolean isExtraInventoryOnLeft() {
        return (Boolean)PetrolparkConfigs.client().extraInventoryLeft.get();
    }

    public static final int getExtraInventoryWidth() {
        return (Integer)PetrolparkConfigs.client().extraInventoryWidth.get();
    }

    public static final ExtraHotbarSlotLocations getExtraHotbarSlotLocations() {
        return (ExtraHotbarSlotLocations)((Object)PetrolparkConfigs.client().extraHotbarSlotLocations.get());
    }

    public static final int getExtraHotbarPrioritySlots() {
        return (Integer)PetrolparkConfigs.client().extraHotbarPrioritySlotCount.get();
    }

    public ExtraInventoryClientSettings getExtraInventoryClientSettings() {
        return new ExtraInventoryClientSettings(ExtendedInventoryClientHandler.isExtraInventoryOnLeft(), ExtendedInventoryClientHandler.getExtraInventoryWidth(), ExtendedInventoryClientHandler.getExtraHotbarSlotLocations(), ExtendedInventoryClientHandler.getExtraHotbarPrioritySlots());
    }

    public static final Rect2i getLeftHotbarLocation(ExtendedInventory inv, Rect2i screenArea, int hotbarY) {
        int slots = ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots());
        if (slots == 0) {
            return null;
        }
        return ExtendedInventoryClientHandler.getHotbarLocation(screenArea, hotbarY, -18 - slots * 18, slots);
    }

    public static final Rect2i getRightHotbarLocation(ExtendedInventory inv, Rect2i screenArea, int hotbarY) {
        int slots = ExtendedInventoryClientHandler.getRightExtraHotbarSlots(inv.getExtraHotbarSlots());
        if (slots == 0) {
            return null;
        }
        return ExtendedInventoryClientHandler.getHotbarLocation(screenArea, hotbarY, screenArea.getWidth() + 4, slots);
    }

    protected static final Rect2i getHotbarLocation(Rect2i screenArea, int hotbarY, int xOffset, int slots) {
        return new Rect2i(screenArea.getX() + xOffset, hotbarY - 7, 14 + slots * 18, 32);
    }

    public static final Rect2i getCombinedInventoryHotbarLocation(ExtendedInventory inv, Rect2i screenArea, int hotbarY) {
        boolean left = ExtendedInventoryClientHandler.isExtraInventoryOnLeft();
        int inventorySlots = inv.extraItems.size() - inv.getExtraHotbarSlots();
        int inventoryWidth = ExtendedInventoryClientHandler.getExtraInventoryWidth();
        int inventoryHeight = inventorySlots / inventoryWidth;
        if (inventorySlots % inventoryWidth > 0) {
            ++inventoryHeight;
        }
        int hotbarSlots = left ? ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots()) : ExtendedInventoryClientHandler.getRightExtraHotbarSlots(inv.getExtraHotbarSlots());
        int width = Math.max(inventoryWidth, hotbarSlots);
        if (hotbarSlots > 0 && inventoryHeight >= 3) {
            return new Rect2i(screenArea.getX() + (left ? -18 - width * 18 : 4 + screenArea.getWidth()), hotbarY - 4 - 18 * inventoryHeight - 7, 14 + width * 18, 18 * (inventoryHeight + 1) + 14 + 4);
        }
        return null;
    }

    public static final Rect2i getInventoryLocation(ExtendedInventory inv, Rect2i screenArea, int hotbarY) {
        int inventorySlots = inv.extraItems.size() - inv.getExtraHotbarSlots();
        if (inventorySlots <= 0) {
            return null;
        }
        int inventoryWidth = ExtendedInventoryClientHandler.getExtraInventoryWidth();
        int inventoryHeight = inventorySlots / inventoryWidth;
        if (inventorySlots % inventoryWidth > 0) {
            ++inventoryHeight;
        }
        return new Rect2i(screenArea.getX() + (ExtendedInventoryClientHandler.isExtraInventoryOnLeft() ? -18 - inventoryWidth * 18 : 4 + screenArea.getWidth()), hotbarY - 4 - 7 - 18 * Math.max(3, inventoryHeight), 14 + inventoryWidth * 18, 14 + 18 * inventoryHeight);
    }

    public static final Rect2i getScreenArea(AbstractContainerScreen<?> screen) {
        Rect2i area = new Rect2i(0, 0, screen.getXSize(), screen.getYSize());
        if (screen instanceof AbstractSimiContainerScreen) {
            AbstractSimiContainerScreen simiScreen = (AbstractSimiContainerScreen)screen;
            for (Rect2i extraArea : simiScreen.getExtraAreas()) {
                area.setX(Math.min(area.getX(), extraArea.getX()));
                area.setWidth(Math.max(area.getWidth(), extraArea.getX() - area.getX() + extraArea.getWidth()));
            }
        }
        return area;
    }

    public void refreshExtraInventoryAreas(ExtendedInventory inv) {
        IExtendedInventoryScreen customScreen;
        if (this.currentScreen == null) {
            return;
        }
        boolean mainInventoryLeft = ExtendedInventoryClientHandler.isExtraInventoryOnLeft();
        AbstractContainerScreen<?> abstractContainerScreen = this.currentScreen;
        if (abstractContainerScreen instanceof IExtendedInventoryScreen && !(customScreen = (IExtendedInventoryScreen)abstractContainerScreen).customExtendedInventoryRendering()) {
            int leftHotbarSlots = ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots());
            this.leftHotbar = customScreen.getLeftHotbarLocation(inv, leftHotbarSlots, mainInventoryLeft);
            this.rightHotbar = customScreen.getRightHotbarLocation(inv, leftHotbarSlots, mainInventoryLeft);
            this.combinedInventoryHotbar = customScreen.getCombinedInventoryHotbarLocation(inv, leftHotbarSlots, mainInventoryLeft);
            this.inventory = customScreen.getInventoryLocation(inv, leftHotbarSlots, mainInventoryLeft);
            this.extraGuiAreas = customScreen.getExtendedInventoryGuiAreas(inv);
        } else {
            Rect2i screenArea = ExtendedInventoryClientHandler.getScreenArea(this.currentScreen);
            int hotbarY = ExtendedInventoryClientHandler.findHotbarY(this.currentScreen);
            this.leftHotbar = ExtendedInventoryClientHandler.getLeftHotbarLocation(inv, screenArea, hotbarY);
            this.rightHotbar = ExtendedInventoryClientHandler.getRightHotbarLocation(inv, screenArea, hotbarY);
            this.combinedInventoryHotbar = ExtendedInventoryClientHandler.getCombinedInventoryHotbarLocation(inv, screenArea, hotbarY);
            this.inventory = ExtendedInventoryClientHandler.getInventoryLocation(inv, screenArea, hotbarY);
            this.extraGuiAreas = new ArrayList<Rect2i>(3);
            if (this.combinedInventoryHotbar == null) {
                if (this.inventory != null) {
                    this.extraGuiAreas.add(ExtendedInventoryClientHandler.offset(this.inventory, this.currentScreen.getGuiLeft(), this.currentScreen.getGuiTop()));
                }
                if (this.leftHotbar != null) {
                    this.extraGuiAreas.add(ExtendedInventoryClientHandler.offset(this.leftHotbar, this.currentScreen.getGuiLeft(), this.currentScreen.getGuiTop()));
                }
                if (this.rightHotbar != null) {
                    this.extraGuiAreas.add(ExtendedInventoryClientHandler.offset(this.rightHotbar, this.currentScreen.getGuiLeft(), this.currentScreen.getGuiTop()));
                }
            } else {
                Rect2i renderedHotbar;
                this.extraGuiAreas.add(ExtendedInventoryClientHandler.offset(this.combinedInventoryHotbar, this.currentScreen.getGuiLeft(), this.currentScreen.getGuiTop()));
                Rect2i rect2i = renderedHotbar = mainInventoryLeft ? this.rightHotbar : this.leftHotbar;
                if (renderedHotbar != null) {
                    this.extraGuiAreas.add(ExtendedInventoryClientHandler.offset(renderedHotbar, this.currentScreen.getGuiLeft(), this.currentScreen.getGuiTop()));
                }
            }
        }
    }

    public static int findHotbarY(AbstractContainerScreen<?> screen) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        int hotbarY = screen.height - 22;
        if (player == null) {
            return hotbarY;
        }
        for (Slot slot : screen.getMenu().slots) {
            if (slot.container != player.getInventory() || !Inventory.isHotbarSlot((int)slot.getSlotIndex())) continue;
            return slot.y;
        }
        return hotbarY;
    }

    public int getLeftmostX() {
        if (ExtendedInventoryClientHandler.isExtraInventoryOnLeft()) {
            if (this.combinedInventoryHotbar != null) {
                return this.combinedInventoryHotbar.getX();
            }
            return Math.min(this.leftHotbar == null ? 0 : this.leftHotbar.getX(), this.inventory == null ? 0 : this.inventory.getX());
        }
        return this.leftHotbar == null ? 0 : this.leftHotbar.getX();
    }

    public void addSlotsToClientMenu(ExtendedInventory inv, AbstractContainerMenu menu) {
        this.addSlotsToClientMenu(inv, arg_0 -> ((AbstractContainerMenu)menu).addSlot(arg_0), Slot::new);
    }

    public void addSlotsToClientMenu(ExtendedInventory inv, Consumer<Slot> slotAdder, ExtendedInventory.SlotFactory slotFactory) {
        int rightY;
        int rightX;
        int leftY;
        int leftX;
        int invY;
        int invX;
        Rect2i inventoryRect;
        Rect2i rect2i = inventoryRect = this.combinedInventoryHotbar == null ? this.inventory : this.combinedInventoryHotbar;
        if (inventoryRect == null) {
            invX = 0;
            invY = 0;
        } else {
            invX = inventoryRect.getX();
            invY = inventoryRect.getY();
        }
        if (this.leftHotbar != null) {
            leftX = this.leftHotbar.getX() + 7;
            leftY = this.leftHotbar.getY() + 7;
        } else {
            leftX = 0;
            leftY = 0;
        }
        if (this.rightHotbar != null) {
            rightX = this.rightHotbar.getX() + 7;
            rightY = this.rightHotbar.getY() + 7;
        } else {
            rightX = 0;
            rightY = 0;
        }
        inv.addExtraInventorySlotsToMenu(slotAdder, slotFactory, ExtendedInventoryClientHandler.getExtraInventoryWidth(), invX + 7, invY + 7, ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots()), leftX, leftY, rightX, rightY);
    }

    @SubscribeEvent
    public void onScreenInitPost(ScreenEvent.Init.Post event) {
        if (!ExtendedInventory.enabled()) {
            return;
        }
        Screen screen = event.getScreen();
        if (!(screen instanceof AbstractContainerScreen)) {
            this.currentScreen = null;
            return;
        }
        AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
        AbstractContainerMenu menu = screen2.getMenu();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (menu == player.inventoryMenu) {
            CatnipServices.NETWORK.sendToServer((CustomPacketPayload)RequestInventoryFullStatePacket.INSTANCE);
        }
        if (!ExtendedInventory.supportsExtraInventory(menu) && menu != player.inventoryMenu && !(screen2 instanceof CreativeModeInventoryScreen)) {
            this.currentScreen = null;
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)mc.player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        if (!(screen2 == this.currentScreen || screen2 instanceof InventoryScreen && this.currentScreen instanceof CreativeModeInventoryScreen)) {
            this.currentScreen = screen2;
            this.refreshExtraInventoryAreas(inv);
        }
        if (menu != player.inventoryMenu && !(screen2 instanceof CreativeModeInventoryScreen) && !(menu instanceof IExtendedInventoryMenu)) {
            this.addSlotsToClientMenu(inv, menu);
            ((ExtendedInventory.DelayedSlotPopulation)menu).populateDelayedSlots();
        }
    }

    @SubscribeEvent
    public void onScreenRenderPre(ScreenEvent.Render.Pre event) {
        Rect2i invRect;
        IExtendedInventoryScreen customScreen;
        AbstractContainerScreen screen;
        Screen screen2;
        if (!ExtendedInventory.enabled() || !((screen2 = event.getScreen()) instanceof AbstractContainerScreen) || (screen = (AbstractContainerScreen)screen2) != this.currentScreen) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        if (screen.getMenu() != player.inventoryMenu && !ExtendedInventory.supportsExtraInventory(screen.getMenu()) && (!(screen instanceof CreativeModeInventoryScreen) || CreativeModeInventoryScreen.selectedTab.getType() != CreativeModeTab.Type.INVENTORY) || screen instanceof IExtendedInventoryScreen && (customScreen = (IExtendedInventoryScreen)screen).customExtendedInventoryRendering()) {
            return;
        }
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)player);
        if (invOp.isEmpty()) {
            // empty if block
        }
        ExtendedInventory inv = invOp.get();
        boolean left = ExtendedInventoryClientHandler.isExtraInventoryOnLeft();
        int leftHotbarSlots = ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(inv.getExtraHotbarSlots());
        int columns = ExtendedInventoryClientHandler.getExtraInventoryWidth();
        GuiGraphics graphics = event.getGuiGraphics();
        PoseStack ms = graphics.pose();
        RenderSystem.enableDepthTest();
        ms.pushPose();
        ms.translate((float)screen.getGuiLeft(), (float)screen.getGuiTop(), 2.0f);
        ms.pushPose();
        ms.translate(-1.0f, -1.0f, 0.0f);
        if (this.combinedInventoryHotbar != null) {
            Rect2i renderedHotbar;
            PetrolparkNineSlices.INVENTORY_BACKGROUND.render(graphics, this.combinedInventoryHotbar);
            Rect2i rect2i = renderedHotbar = left ? this.rightHotbar : this.leftHotbar;
            if (renderedHotbar != null) {
                PetrolparkNineSlices.INVENTORY_BACKGROUND.render(graphics, renderedHotbar);
            }
        } else {
            if (this.inventory != null) {
                PetrolparkNineSlices.INVENTORY_BACKGROUND.render(graphics, this.inventory);
            }
            if (this.leftHotbar != null) {
                PetrolparkNineSlices.INVENTORY_BACKGROUND.render(graphics, this.leftHotbar);
            }
            if (this.rightHotbar != null) {
                PetrolparkNineSlices.INVENTORY_BACKGROUND.render(graphics, this.rightHotbar);
            }
        }
        ms.popPose();
        if (this.leftHotbar != null) {
            for (int i = 0; i < leftHotbarSlots; ++i) {
                PetrolparkGuiTexture.INVENTORY_SLOT.render(graphics, this.leftHotbar.getX() + 7 - 1 + i * 18, this.leftHotbar.getY() + 7 - 1);
            }
        }
        int j = 0;
        if (this.rightHotbar != null) {
            for (int i = leftHotbarSlots; i < inv.getExtraHotbarSlots(); ++i) {
                PetrolparkGuiTexture.INVENTORY_SLOT.render(graphics, this.rightHotbar.getX() + 7 - 1 + j * 18, this.rightHotbar.getY() + 7 - 1);
                ++j;
            }
        }
        j = 0;
        Rect2i rect2i = invRect = this.combinedInventoryHotbar == null ? this.inventory : this.combinedInventoryHotbar;
        if (invRect != null) {
            for (int i = inv.getExtraHotbarSlots(); i < inv.extraItems.size(); ++i) {
                PetrolparkGuiTexture.INVENTORY_SLOT.render(graphics, invRect.getX() + 7 - 1 + 18 * (j % columns), invRect.getY() + 7 - 1 + j / columns * 18);
                ++j;
            }
        }
        ms.popPose();
    }

    @SubscribeEvent
    public void onScreenClosing(ScreenEvent.Closing event) {
        this.currentScreen = null;
    }

    public static void renderExtraHotbarBackground(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (!ExtendedInventory.enabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        MultiPlayerGameMode gameMode = mc.gameMode;
        if (player == null || mc.options.hideGui || gameMode == null || gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        PoseStack ms = graphics.pose();
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        int extraSlots = inv.getExtraHotbarSlots();
        int y = graphics.guiHeight() - 22;
        RenderSystem.enableDepthTest();
        for (boolean right : Iterate.trueAndFalse) {
            int slotCount;
            int x = graphics.guiWidth() / 2 - 91;
            if (right) {
                slotCount = ExtendedInventoryClientHandler.getRightExtraHotbarSlots(extraSlots);
                x += 180;
            } else {
                slotCount = ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(extraSlots);
                x -= slotCount * 20;
            }
            ms.pushPose();
            if (slotCount > 0) {
                PetrolparkNineSlices.HOTBAR.render(graphics, x, y, 2 + slotCount * 20, 22);
            }
            ms.popPose();
        }
    }

    public static void renderExtraHotbar(GuiGraphics graphics, DeltaTracker deltaTracker) {
        if (!ExtendedInventory.enabled()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        MultiPlayerGameMode gameMode = mc.gameMode;
        if (player == null || mc.options.hideGui || gameMode == null || gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        PoseStack ms = graphics.pose();
        Optional<ExtendedInventory> invOp = ExtendedInventory.get((Player)player);
        if (invOp.isEmpty()) {
            return;
        }
        ExtendedInventory inv = invOp.get();
        int extraSlots = inv.getExtraHotbarSlots();
        int y = graphics.guiHeight() - 21;
        RenderSystem.enableDepthTest();
        int item = 0;
        for (boolean right : Iterate.trueAndFalse) {
            int slotCount;
            int x = graphics.guiWidth() / 2 - 90;
            if (right) {
                slotCount = ExtendedInventoryClientHandler.getRightExtraHotbarSlots(extraSlots);
                x += 180;
            } else {
                slotCount = ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(extraSlots);
                x -= slotCount * 20;
            }
            if (slotCount == 0) continue;
            ms.pushPose();
            for (int i = 0; i < slotCount; ++i) {
                PetrolparkGuiTexture.HOTBAR_SLOT.render(graphics, x + i * 20, y);
                mc.gui.renderSlot(graphics, 2 + x + i * 20, y + 2, deltaTracker, (Player)player, (ItemStack)inv.extraItems.get(item), 42069);
                ++item;
            }
            ms.popPose();
        }
        ms.pushPose();
        int selected = inv.getSelectedHotbarIndex();
        int selectedX = graphics.guiWidth() / 2 - 92;
        if (inv.getSelectedHotbarIndex() >= Inventory.getSelectionSize() + ExtendedInventoryClientHandler.getRightExtraHotbarSlots(extraSlots)) {
            selectedX -= ExtendedInventoryClientHandler.getLeftExtraHotbarSlots(extraSlots) * 20;
            selected -= Inventory.getSelectionSize() + ExtendedInventoryClientHandler.getRightExtraHotbarSlots(extraSlots);
        }
        graphics.blitSprite(Gui.HOTBAR_SELECTION_SPRITE, selectedX += selected * 20, y - 2, 24, 23);
        ms.popPose();
    }

    public List<Rect2i> getGuiExtraAreas() {
        if (this.currentScreen == null) {
            return Collections.emptyList();
        }
        return this.extraGuiAreas;
    }

    private static Rect2i offset(Rect2i rect, int x, int y) {
        return new Rect2i(rect.getX() + x, rect.getY() + y, rect.getWidth(), rect.getHeight());
    }

    public record ExtraInventoryClientSettings(boolean left, int width, ExtraHotbarSlotLocations loc, int hotbarCount) {
    }

    public static enum ExtraHotbarSlotLocations {
        ALL_LEFT,
        ALL_RIGHT,
        START_LEFT,
        START_RIGHT,
        PRIORITY_LEFT,
        PRIORITY_RIGHT;

    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="petrolpark")
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerBelow(VanillaGuiLayers.HOTBAR, Petrolpark.asResource("extra_hotbar_background"), ExtendedInventoryClientHandler::renderExtraHotbarBackground);
            event.registerAbove(VanillaGuiLayers.HOTBAR, Petrolpark.asResource("extra_hotbar"), ExtendedInventoryClientHandler::renderExtraHotbar);
        }
    }
}

