/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.petrolpark.Petrolpark;
import com.petrolpark.core.contamination.recipe.IHandleContaminationMyselfRecipe;
import com.petrolpark.core.item.decay.ItemDecay;
import com.petrolpark.util.CodecHelper;
import io.netty.handler.codec.DecoderException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;

public class DecayingItemCookingRecipe
extends AbstractCookingRecipe
implements IHandleContaminationMyselfRecipe<SingleRecipeInput> {
    public static final MapCodec<DecayingItemCookingRecipe> CODEC = CodecHelper.singleFieldMap(Recipe.CODEC.comapFlatMap(r -> {
        DataResult dataResult;
        if (r instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe cr = (AbstractCookingRecipe)r;
            dataResult = DataResult.success((Object)cr);
        } else {
            dataResult = DataResult.error(() -> "Not a cooking recipe");
        }
        return dataResult;
    }, Function.identity()), "recipe", DecayingItemCookingRecipe::getWrappedRecipe, DecayingItemCookingRecipe::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, DecayingItemCookingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Recipe.STREAM_CODEC.map(r -> {
        if (r instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe cr = (AbstractCookingRecipe)r;
            return cr;
        }
        throw new DecoderException("Not a cooking recipe");
    }, Function.identity()), DecayingItemCookingRecipe::getWrappedRecipe, DecayingItemCookingRecipe::new);
    protected final AbstractCookingRecipe wrappedRecipe;
    public static final RecipeSerializer<DecayingItemCookingRecipe> SERIALIZER = new RecipeSerializer<DecayingItemCookingRecipe>(){

        public MapCodec<DecayingItemCookingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, DecayingItemCookingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    };

    public static ItemStack withDecay(ItemStack stack) {
        return (ItemStack)Petrolpark.runForDist(() -> () -> stack, () -> () -> {
            ItemStack copy = stack.copy();
            ItemDecay.startDecay(copy);
            return copy;
        });
    }

    public DecayingItemCookingRecipe(AbstractCookingRecipe wrappedRecipe) {
        super(wrappedRecipe.getType(), wrappedRecipe.getGroup(), wrappedRecipe.category(), (Ingredient)wrappedRecipe.getIngredients().get(0), wrappedRecipe.result, wrappedRecipe.getExperience(), wrappedRecipe.getCookingTime());
        this.wrappedRecipe = wrappedRecipe;
    }

    public AbstractCookingRecipe getWrappedRecipe() {
        return this.wrappedRecipe;
    }

    public ItemStack assemble(@Nonnull SingleRecipeInput input, @Nonnull HolderLookup.Provider registries) {
        return DecayingItemCookingRecipe.withDecay(super.assemble(input, registries));
    }

    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return DecayingItemCookingRecipe.withDecay(super.getResultItem(registries));
    }

    public RecipeSerializer<? extends AbstractCookingRecipe> getSerializer() {
        return SERIALIZER;
    }
}

