/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay.ageing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.PetrolparkRecipeSerializers;
import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.core.item.decay.DecayTime;
import com.petrolpark.core.item.decay.ItemDecay;
import com.petrolpark.core.item.decay.product.IDecayProduct;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public record AgeingRecipe(Ingredient ingredient, IDecayProduct product, DecayTime decayTime) implements Recipe<SingleRecipeInput>
{
    public static final MapCodec<AgeingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(AgeingRecipe::ingredient), (App)IDecayProduct.CODEC.fieldOf("product").forGetter(AgeingRecipe::product), (App)Codec.withAlternative(DecayTime.CODEC, DecayTime.INLINE_CODEC).fieldOf("time").forGetter(AgeingRecipe::decayTime)).apply((Applicative)instance, AgeingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AgeingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, AgeingRecipe::ingredient, IDecayProduct.STREAM_CODEC, AgeingRecipe::product, DecayTime.STREAM_CODEC, AgeingRecipe::decayTime, AgeingRecipe::new);

    public boolean matches(@Nonnull SingleRecipeInput input, @Nonnull Level level) {
        IDecayProduct product = (IDecayProduct)input.item().get(PetrolparkDataComponents.DECAY_PRODUCT);
        return this.ingredient().test(input.item()) && (product == null || product.equals(this.product()));
    }

    public ItemStack setDecayProductAndTime(ItemStack stack) {
        stack.set(PetrolparkDataComponents.DECAY_PRODUCT, (Object)this.product);
        stack.set(PetrolparkDataComponents.DECAY_TIME, (Object)this.decayTime);
        return stack;
    }

    public ItemStack assemble(@Nonnull SingleRecipeInput input, @Nonnull HolderLookup.Provider registries) {
        return this.assemble(input, true);
    }

    public ItemStack assemble(@Nonnull SingleRecipeInput input, boolean startDecay) {
        ItemStack result = input.item().copy();
        this.setDecayProductAndTime(result);
        if (startDecay) {
            ItemDecay.startDecay(result);
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(@Nonnull HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<AgeingRecipe> getSerializer() {
        return (RecipeSerializer)PetrolparkRecipeSerializers.AGEING.get();
    }

    public RecipeType<AgeingRecipe> getType() {
        return (RecipeType)PetrolparkRecipeTypes.AGEING.get();
    }

    public static final AgeingRecipe cast(Recipe<SingleRecipeInput> recipe) {
        if (recipe instanceof AgeingRecipe) {
            AgeingRecipe ageingRecipe = (AgeingRecipe)recipe;
            return ageingRecipe;
        }
        return null;
    }
}

