/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay.product;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.PetrolparkDecayProductTypes;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.ContaminationLootItemFunction;
import com.petrolpark.core.contamination.ItemContamination;
import com.petrolpark.core.item.decay.product.DecayProductType;
import com.petrolpark.core.item.decay.product.IDecayProduct;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record ContaminateDecayProduct(Holder<Contaminant> contaminantHolder, ContaminationLootItemFunction.Action action) implements IDecayProduct
{
    public static final MapCodec<ContaminateDecayProduct> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Contaminant.CODEC.fieldOf("contaminant").forGetter(ContaminateDecayProduct::contaminantHolder), (App)ContaminationLootItemFunction.Action.CODEC.optionalFieldOf("action", (Object)ContaminationLootItemFunction.Action.ADD).forGetter(ContaminateDecayProduct::action)).apply((Applicative)instance, ContaminateDecayProduct::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ContaminateDecayProduct> STREAM_CODEC = StreamCodec.composite(Contaminant.STREAM_CODEC, ContaminateDecayProduct::contaminantHolder, ContaminationLootItemFunction.Action.STREAM_CODEC, ContaminateDecayProduct::action, ContaminateDecayProduct::new);

    @Override
    public ItemStack get(ItemStack stack) {
        this.action().apply(ItemContamination.get(stack), this.contaminantHolder);
        return stack;
    }

    @Override
    public DecayProductType getType() {
        return (DecayProductType)PetrolparkDecayProductTypes.CONTAMINATE.get();
    }

    @Override
    public final boolean equals(Object other) {
        ContaminateDecayProduct cdp;
        if (this == other) {
            return true;
        }
        return other instanceof ContaminateDecayProduct && (cdp = (ContaminateDecayProduct)other).action() == this.action() && cdp.contaminantHolder().equals(this.contaminantHolder());
    }
}

